//==============================================================================
//  Fichier : serial.h
//  
//  Description de fonctions utilisées pour la communication série
//==============================================================================
//              Déclarations des ressources
//#include "soft_uart.h"
#include "mbed.h"
//==============================================================================


//==============================================================================
//              Déclaration des variables
char cmd[10];                           // tableau de variable de type caractère
char buf[10];
int ptr, k;
int config_menu;

//==============================================================================
void Init_Serial(void)
{
    ptr = 0;
    config_menu = 1;
//    k = 0;

  //  init_uart();                        // Initialise la liaison série soft
  //  printStr("FabLab Bluetooth\r\n");
}

void Commande_Up(void)
{
/*    if (kbhit())                    // Un caractère est reçu sur le BT
    {
        buf[k] = _getchar();        // Mémorise le carcatère dans un tableau
        
        if((buf[k] == 0x0A) || (buf[k] == 0x0D))      // Test touche entrée en mode ASCII
        {
            buf[k] = 0;             // Transforme le tableau en chaine de caractères  
            k = 0;                  // Met le pointeur à 0
            pc.printf("%s\n\r",buf);     // Envoi le texte vers le PC 
        }
        else
        {
            k++;                // incrémente pour lire le prochain caractère
        }
        
    }
*/
    if(pc.readable())                  // Si appui caractère au clavier
    {
        cmd[ptr] = pc.getc();       // Mémorise le caractère et vide le registre de réception
        
        if((cmd[ptr] == 0x0A) || (cmd[ptr] == 0x0D))      // Test touche entrée en mode ASCII
        {
            cmd[ptr] = 0;         // Transforme le tableau en chaine de caractères  
            ptr = 0;

            if(config_menu & 0x01)         // Controle Echo On/Off
            {
                pc.printf("%s\n\r",cmd);     // Envoi le texte vers le PC 
            }
        }
        else
        {
            ptr++;
        }
    }
}

void Menu(void)
{

    if(cmd[0] == '$')
    {
        switch (cmd[1])
        {
            case 'A':                   //  Anémomètre On
                config_menu = config_menu | 0b00000010;
                break;
            case 'a':                   //  Anémomètre Off
                config_menu = config_menu & 0b11111101;
                break;
            case 'E':                   //  Echo du message On
                config_menu = config_menu | 0b00000001;
                break;
            case 'e':                   //  Echo du message Off
                config_menu = config_menu & 0b11111110;
                break;
            case 'T':                   //  Thermomètre On
                config_menu = config_menu | 0b00000100;
                break;
            case 't':                   //  Thermomètre Off
                config_menu = config_menu & 0b11111011;
                break;
            default:
                break;
        }
    }
}

int Get_Config(void)
{
    return config_menu;
}
