//==============================================================================
//  Fichier : anemo.h
//  
//  Description de fonctions utilisées pour la station météo
//==============================================================================
//              Déclaration des variables et des constantes

InterruptIn  Anem(PB_4);                // La ligne est déclarée en interruption
Timer Fenetre_Temps;                    // Déclaration d'un compteur
Ticker Tick_Anemo;

uint16_t nombre;
int16_t vitesse_anemo;                          // vitesse anemometre
uint8_t etat_anemo;
uint8_t anemo_ok;

void ISR_Compteur(void)                 // Fonction d'interruption (Interrupt Sub Routine)
{
    nombre++;                           // Compte le nombre de rotation de l'axe
}

void Init_Anemo(void)
{
    Anem.mode(PullUp);                  // Activation résistance de Pullup
    etat_anemo = 0;                     // Initialisation de la machine à états
    anemo_ok = 0;                       // Lecture non disponible
}
//==============================================================================
//              Fonction : Gestion Anemometre
//  Entrée : On Off de la tache
//  Sortie : Pas de paramètre en sortie
//  Interne: variable d'état et de mesure

void Gestion_Anemometre (unsigned int val_anemo)
{
    switch (etat_anemo)
    {
    case 0:         // Tache au repos
        if((val_anemo & 0x02) == 0x02)
            etat_anemo = 1;
        else
        {
            anemo_ok = 0;
            Fenetre_Temps.stop();              // Mettre à 0
            Anem.disable_irq();
        }
        break;
    case 1:
        Fenetre_Temps.start();              // Déclenche le timer
        Fenetre_Temps.reset();              // Mettre à 0
        Anem.rise(&ISR_Compteur);           // Interruption sur front montant
        Anem.fall(&ISR_Compteur);           // et sur front descendant
        Anem.enable_irq();
    
        etat_anemo = 2;
        break;
    case 2:
        if(Fenetre_Temps.read_ms() >= 1000)      // Mesure d'une fréquence
        {
            vitesse_anemo = nombre/2;       // Formule de conversion
            nombre = 0;
            Fenetre_Temps.stop();              // Mettre à 0
            etat_anemo = 3;
        }
        break;
    case 3:                                 // Lecture disponible
        anemo_ok = 1;
        etat_anemo = 0;
        break;
    default:
        etat_anemo = 0;
        break;    
    }
}
//==============================================================================
//              Fonction : Lecture Anemometre
//  Entrée : Pas de paramètres en entrée
//  Sortie : vitesse anemometre
//  Interne: variable d'état

int Lecture_Anemometre(void)
{
int resultat;

    if (anemo_ok == 1)
    {
        resultat = vitesse_anemo;
        anemo_ok = 0;
    }
    else
    {
        resultat = 0;
    }
    return resultat;
}
//==============================================================================
//  Nucleo - L031K6

//  PA_9                    Vin
//  PA_10                   Gnd
//  NRST                    NRST
//  Gnd                     5V
//  PA_12                   PA_2
//  PB_0                    PA_7
//  PB_7                    PA_6
//  PB_6                    PA_5
//  PB_1                    PA_4
//  NC                      PA_3
//  NC                      PA_1
//  PA_8                    PA_0
//  PA_11                   Aref
//  PB_5                    3V3
//  PB_4                    PB_3


