//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 26 mars 2022
//  TP : Station Météo
//  Test Liaison I2C
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"

//==============================================================================
//              Déclaration des broches
DigitalOut  DEL_RO(PA_11);              // Ligne PA_11 sur la carte Nucléo
Serial      pc(USBTX, USBRX);           // Dialogue Série port USB à 9600 Baud
I2C  i2c(PB_7, PB_6);              // I2C SDA, SCL
//I2C i2c(I2C_SDA, I2C_SCL);

//==============================================================================
//              Déclaration des variables
uint8_t variable;                        // variable de type entier (0 à 255)
char c;                                 // variable de type caractère
float temp;                             // variable de type réel
uint16_t mesure;

#define EEPROM_ADR   0b10100000         // EEPROM adresse 24C16 16kbits

char data[1];
char data_write[3];                     // Array for adresse and data
uint8_t i;

//==============================================================================
//              Déclaration des Fonctions
void Ma_Fonction(void)
{
    variable = 0;
}

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{
// Autres valeurs standard : 9600 19200 38400 57600 115200
//    pc.baud(38400);
    pc.printf("\r\nFabLab Test I2C\r\n\n");
//  Test de l'horloge Systeme
//    pc.printf("Horloge CPU a %d Hz\r\n", SystemCoreClock);

    i2c.frequency(100000);
 
// Type in address
    data_write[0] = 0;          // Adresse poids fort
    data_write[1] = 0;          // Adresse poids faible
// Type data
    data_write[2] = 1;          // Donnée
    
    
    for( i = 0; i < 255; i++ )
    {
        data_write[1] = i;
        data_write[2] = i;
        i2c.write(EEPROM_ADR, data_write, 3);
        wait_ms(6); // Wait eeprom internal write cycle (5ms) + 1ms
    }
    
char reg_adr[2] = {0,0};

    i2c.write(EEPROM_ADR, reg_adr, 2, true);
    i2c.read(EEPROM_ADR, data, 1, false);
    pc.printf("Nb ecriture: %d\n\r",data[0]);

//==============================================================================
//              Boucle Infinie
    while(1)
    {
        i2c.read(EEPROM_ADR, data, 1);
        pc.printf("%d\n\r",data[0]);
        wait_ms(500);
    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================