//==============================================================================
//  Fichier : fonctions.h
//  
//  Description de fonctions utilisées pour la station météo
//==============================================================================
#include "mbed.h"
//              Déclaration des variables et des constantes
               
InterruptIn  Anem(PB_4);                // La ligne est déclarée en interruption
Timer Fenetre_Temps;                    // Déclaration d'un compteur

uint16_t nombre;

void ISR_Compteur(void)                 // Fonction d'interruption (Interrupt Sub Routine)
{
    nombre++;                           // Compte le nombre de rotation de l'axe
}

void Init_Fonctions(void)
{
    Anem.mode(PullUp);                  // Activation résistance de Pullup
    Fenetre_Temps.start();              // Déclenche le timer
    Anem.rise(&ISR_Compteur);           // Interruption sur front montant
    Anem.fall(&ISR_Compteur);
}
//==============================================================================
//              Fonction : Girouette
//  Entrée : Pas de paramètres en entrée
//  Sortie : vitesse du vent en 16bits

// this function has 63 bytes write limit
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB
 
    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }
 
    int result = i2c.write(address, i2cBuffer, size + 2, false);
    wait_ms(6);
}

//  Nucleo - L432KC - L031K6

//  PA_9                    Vin
//  PA_10                   Gnd
//  NRST                    NRST
//  Gnd                     5V
//  PA_12                   PA_2
//  PB_0                    PA_7
//  PB_7    SDA             PA_6
//  PB_6    SCL             PA_5
//  PB_1                    PA_4
//  NC                      PA_3
//  NC                      PA_1
//  PA_8                    PA_0    AN0
//  PA_11                   Aref
//  PB_5                    3V3
//  PB_4                    PB_3