//==============================================================================
//  Fichier : fonctions.h
//  
//  Description de fonctions utilisées pour la station météo
//==============================================================================
//              Déclaration des variables et des constantes

//  Tableau de correspondance des angles avec l'encodeur optique
const int16_t table[32] = {  -1,  0, 72, 12,144,132, 84,120,
                            216,348,204, 24,156,168,192,180,
                            288,300, 60, 48,276,312, 96,108,
                            228,336,240, 36,264,324,252, -1};
               
DigitalIn  B0(PB_4);                    // Encodeur bit de poids faible
DigitalIn  B1(PB_5);
DigitalIn  B2(PA_11);
DigitalIn  B3(PA_8);
DigitalIn  B4(PB_1);                    // Encodeur bit de poids fort

DigitalOut  CMD_LED_IR(PB_6);           // Commande des 5 Leds infrarouges

void Init_Fonctions(void)
{
//    B0.mode(PullUp);
//    B1.mode(PullUp);
//    B2.mode(PullUp);
//    B3.mode(PullUp);
//    B4.mode(PullUp);
}
//==============================================================================
//              Fonction : Girouette
//  Entrée : Pas de paramètres en entrée
//  Sortie : Angle, multiple de 12° et -1 en cas d'erreur.

int16_t Girouette (void)
{
uint16_t direction = 0;                          // variable initialisée à 0
//  Activation des 5 Leds infrarouges
    CMD_LED_IR = 1;
//  Délai pour laisser le temps aux aux Leds IR de s'activer
    wait_us(50);    
//  Lecture de l'encodeur optique issu de la girouette
    direction = B0;                 // Bit de poids faible à droite
    direction |= (B1<<1);
    direction |= (B2<<2);
    direction |= (B3<<3);
    direction |= (B4<<4);           // Bit de poids fort en position 5
    direction = direction & 0b00011111;
//  Résultat -> direction = 0b000 B4 B3 B2 B1 B0    
//  Coupure des 5 Leds infrarouges
    CMD_LED_IR = 0;
//  Conversion en angle par lecture dans la table    
    return table[direction];
}