//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 24 mars 2022
//  TP : Liaison Bluetooth
//  
//  Utilisation de fonctions décrites dans un fichier séparé
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"
#include "fonctions.h"                  // Appel des fonctions du fichier : fonctions.h
#include "soft_uart.h"

//==============================================================================
//              Déclaration des broches
DigitalOut  DEL(PA_11);              // Ligne PA_11 sur la carte Nucléo
Serial      pc(USBTX, USBRX);           // Dialogue Série port USB à 9600 Baud

//==============================================================================
//              Déclaration des variables

char c;                                 // variable de type caractère
float temp;                             // variable de type réel
int16_t vitesse;                        // variable de type 16 bits signée
char tab[10];                           // tableau de variable de type caractère
char buf[10];
uint8_t ptr, k;

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{
    Init_Fonctions();                   // Exécute cette fonction
    pc.printf("\r\nFabLab Bluetooth\r\n\n");
    
    init_uart();                        // Initialise la liaison série soft
    printStr("FabLab Bluetooth\r\n");
    ptr = 0;
    k = 0;

//==============================================================================
//              Boucle Infinie
    while(1)
    {
        if (kbhit())                    // Un caractère est reçu sur le BT
        {
            buf[k] = _getchar();        // Mémorise le carcatère dans un tableau
            
            if((buf[k] == 0x0A) || (buf[k] == 0x0D))      // Test touche entrée en mode ASCII
            {
                buf[k] = 0;             // Transforme le tableau en chaine de caractères  
                k = 0;                  // Met le pointeur à 0
                pc.printf("%s\n\r",buf);     // Envoi le texte vers le PC 
            }
            else
            {
                k++;                // incrémente pour lire le prochain caractère
            }
            
        }
        if(pc.readable())                  // Si appui caractère au clavier
        {
            tab[ptr] = pc.getc();       // Mémorise le caractère et vide le registre de réception
            
            if((tab[ptr] == 0x0A) || (tab[ptr] == 0x0D))      // Test touche entrée en mode ASCII
            {
                tab[ptr] = 0;         // Transforme le tableau en chaine de caractères  
                ptr = 0;
                printStr(tab);          // Envoi le texte vers le BT
                printStr("\r\n");  
            }
            else
            {
                ptr++;
            }
        }

    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================