//==============================================================================
//  Fichier : fonctions.h
//  
//  Description de fonctions utilisées pour la station météo
//==============================================================================
#include "mbed.h"
//              Déclaration des variables et des constantes
               
InterruptIn  Anem(PB_4);                // La ligne est déclarée en interruption
Timer Fenetre_Temps;                    // Déclaration d'un compteur

uint16_t nombre;

void ISR_Compteur(void)                 // Fonction d'interruption (Interrupt Sub Routine)
{
    nombre++;                           // Compte le nombre de rotation de l'axe
}

void Init_Fonctions(void)
{
    Anem.mode(PullUp);                  // Activation résistance de Pullup
    Fenetre_Temps.start();              // Déclenche le timer
    Anem.rise(&ISR_Compteur);           // Interruption sur front montant
}
//==============================================================================
//              Fonction : Girouette
//  Entrée : Pas de paramètres en entrée
//  Sortie : vitesse du vent en 16bits

int16_t Anemometre (void)
{
int16_t vit;                          // variable locale

    if(Fenetre_Temps.read_ms() > 1000)      // Mesure d'une fréquence
    {
        vit = nombre/4;                 // Formule de conversion
        nombre = 0;
        Fenetre_Temps.reset();
    }
    else
    {
        vit = -1;                       // Lecture non disponible
    }
    return vit;
}

//  Nucleo - L432KC

//  PA_9                    Vin
//  PA_10                   Gnd
//  NRST                    NRST
//  Gnd                     5V
//  PA_12                   PA_2
//  PB_0                    PA_7
//  PB_7                    PA_6
//  PB_6                    PA_5
//  PB_1                    PA_4
//  NC                      PA_3
//  NC                      PA_1
//  PA_8                    PA_0
//  PA_11                   Aref
//  PB_5                    3V3
//  PB_4                    PB_3


