//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 3 dec. 2021
//  TP 04 : Communication série avec le PC
//  Faire varier la luminosité de la DEL par appui sur la touche 'p' ou 'm'
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"

//==============================================================================
//              Déclaration des broches
PwmOut DEL(PA_8);                      // Ligne PA_11 en mode PWM
Serial pc(USBTX, USBRX);                // Dialogue Série port USB à 9600 Baud

//==============================================================================
//              Déclaration des variables
int8_t variable;                        // variable de type entier (0 à 255)
char c;                                 // variable de type caractère

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{ 
    pc.printf("\r\nFabLab TP 4\r\n\n");     //  Affiche un message sur le PC
    pc.printf("p -> pour augmenter la luminosite\r\n");
    pc.printf("m -> pour diminuer la luminosite\r\n");
        
    variable = 0;
    DEL.period_ms(20);                // Définit la période du signal
//==============================================================================
//              Boucle Infinie
    while(1)
    {
        if (pc.readable() == 1)              // Une commande a été reçue
        {
            c = pc.getc();              // Lire et mémoriser le caractère reçu
            if(c == 'p')                // Si le caractère est : p
            {
                variable++;             // Augmente la variable de +1
                if(variable > 20)
                    variable = 20;      // Limite supérieure à 20
            }
            if(c == 'm')                // Si le caractère est : m
            {
                if(variable > 0)        // Limite inférieure à 0
                    variable--;         // Diminuer la variable de -1
            }
            
            pc.printf("     val -> %2d\r",variable);  // Affiche la variable sur le PC
        }
        DEL.pulsewidth_ms(variable);    // Définit la durée du temps haut (en ms)
        
    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================