//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 30 oct. 2021
//  TP 02 : Gestion d'un feu de traffic avec bouton piéton
//  Feu Vert : 5s   Feu Orange : 2s Feu Rouge : 3s
//  Appel piéton uniquement pendant le feu vert. Fait passer immédiatement à l'Orange
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"

//==============================================================================
//              Déclaration des broches
DigitalOut DEL_RO(PA_11);               // Ligne PA_11 sur la carte Nucléo
DigitalOut DEL_OR(PB_5);                // Ligne PB_5 sur la carte Nucléo
DigitalOut DEL_VE(PB_4);                // Ligne PB_4 sur la carte Nucléo
DigitalIn  BP(PA_1);                    // Ligne PA_1

//==============================================================================
//              Déclaration des variables
uint8_t etat;                           // variable de type entier non signé
uint8_t compteur;

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{
    BP.mode(PullUp);                    // Activation de la résistance interne vers le +
    
    etat = 0;                         // Initialisation de la variable
    compteur = 0;              
//==============================================================================
    while(1)                            // Boucle Infinie
    {
        wait_ms(100);                   // Temporisation de 100ms (0.1s)
        compteur++;                     // variable représentant un multiple de 100ms
        
        switch(etat)                    // Structure pour plusieurs états du système
        {
            case 0:             //  Etat "Feu Vert"
                DEL_RO = 0;
                DEL_VE = 1;     //  Actions visibles (éteindre et allumer)
                
                if(compteur == 50 || BP == 0)   // Test d'une condition
                {
                    compteur = 0;
                    etat = 1;   //  Changement d'état pour la prochaine boucle
                }
                break;
            case 1:             //  Etat "Feu Orange"
                DEL_VE = 0;
                DEL_OR = 1;     //  Actions visibles
                
                if(compteur == 20)
                 {
                    compteur = 0;
                    etat = 2;
                }
                break;
            case 2:             //  Etat "Feu Rouge"
                DEL_OR = 0;
                DEL_RO = 1;     //  Actions visibles
                
                if(compteur == 30)
                {
                    compteur = 0;
                    etat = 0;
                }
                break;
            default:            // En cas de plantage du programme
                etat = 0;
                break;
        }

    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================