/* WHACK-A-MOLE
This code executes a whack-a-mole style game using LEDs and buttons and 
depending on the performance of the user, will either give the user a high five
or open up a rotating door to shoot the user with a nerf bullet. 
Cadet Seth Shields
MIDN Joseph Brock
MIDN Marco McGavick
MIDN Vincent Potente
*/

#include "mbed.h"
#include "stdlib.h"
#include "stdio.h"
#include "Servo.h"
#include "Motor.h"//include all necessary libraries for the code

DigitalOut leds[4] = {p25, p24, p23, p28};//the "moles", LEDs
DigitalOut ledz[2] = {p27,p12};//show failure or success on each press
DigitalIn button[4] = {p17, p18, p19, p20};//buttons to whack the mole
Motor z(p26,p30,p29);//motor to open rotating door
Servo myservo(p21);//guntrigger 
Servo hmyservo(p22);//hand high five

float hpos;//position of hand
float pos;//position of bar which pulls trigger
float f; //Motor speed
int r; //used for randomly lighting LEDs
int i; //counter
int s; // seed
int k; // preventative variable
int l; // preventative variable
int m; // preventative variable
int n; // preventative variable
int o; // preventative variable
int w = 0; //counter for successful attempts
int x; //count the number of times the motor runs
float timer;//times the motor

int main() {
    
    myservo.calibrate(0.0009,90.0);
    myservo=0.0;//calibrates guntrigger
    hmyservo.calibrate(0.0009,90.0);
    hmyservo=0.0;//calibrates hand
    printf("how hard(0.05 is difficult, 0.2 is easier)\n\r");//change difficulty of game
    scanf("%f", &timer); //input for difficulty
    printf("Enter ten digit number\n\r");//seed for random generated numbers to light LEDs
    scanf("%10d\n\r",&s);//input seed
    srand(s);
    k=0;//initialize k to 0
    wait(3);//begin game
    
    for (i=0; i<10; i++){ //for loop 10 times
        r = rand()%4;//generate random number 0 to 3
        leds[r] = 1;//light up one of the leds
        wait(0.3);//have 0.3 seconds to respond
        
        if (button[r] == 1) {//if good response
            printf("noice\n\r");//good
            ledz[0]=1;//flash good LED
            wait(.2);
            ledz[0]=0;//turn off good LED
            leds[r] = 0;//turn off mole LED
            k=1; // ensure fail code isn't activated
            }//turn off again and loop
            wait(timer);//have determined difficulty time to respond
             
        if (button[r] == 1) {//if good response
            printf("noice\n\r");//good
            ledz[0]=1;
            wait(.2);
            ledz[0]=0;
            leds[r] = 0;//same as above
            l=1;//next counter variable
            }//turn off again and loop
            wait(timer);//have determined difficulty seconds to respond
             
        if (button[r] == 1) {//if good response
            printf("noice\n\r");//good
            ledz[0]=1;
            wait(0.2);
            ledz[0]=0;
            leds[r] = 0;//same as above
            m=1;//next counter variable
            }//turn off again and loop
            wait(timer);//have determined difficulty seconds to respond
             
        if (button[r] == 1) {//if good response
            printf("noice\n\r");//good
            ledz[0]=1;
            wait(.2);
            ledz[0]=0;
            leds[r] = 0;//same as above
            n=1;//next counter variable
            }//turn off again and loop
            wait(timer);//have determined difficulty seconds to respond
             
        if (button[r] == 1) {//if good response
            printf("noice\n\r");//good
            ledz[0]=1;
            wait(.2);
            ledz[0]=0;
            leds[r] = 0;//same as above
            o=1;//next counter variable
            }//turn off again and loop
            
    
            
        if (k==0 && l==0 && m==0 && n==0 && o==0) {printf("fail\n\r");//if you did not hit the button on time
        leds[r]=0;//turn off LED
        ledz[1]=1;//turn on fail LED
        wait(.25);
        ledz[1]=0;//turn off fail LED
        }//if
        
        if (k==1 || l==1 || m==1 || n==1 ||o==1) {w = w + 1;//if you hit the button in the alotted time
        }//end if, w variable counts successes, adds one to w
        leds[r]=0;
        k=0;
        l=0;
        m=0;
        n=0;
        o=0;//reset all variables for next light up
        printf("%d\n\r", r);
        
        
        
        
      }//for
  
    printf("you got %d out of 10 right!\n\r", w);//display how many successful pushes
    
    if (w < 9) {//if 9 or less out of 10, gun trigger
       
        f = -1.0;//initialize f
        z.speed(f);//activate motor
        wait(.1);
        z.speed(0);//stop motor
        
        
        for (pos =0.0; pos<=10.0; pos=pos+10.0) {
            myservo=(pos/10.0);
            wait (0.07);
            printf("%f\n",pos);
        }//ends for
        for (pos =10.0; pos>=0.0; pos=pos-10.0) {
            myservo=(pos/10.0);
            wait (0.07);
            printf("%f\n",pos); // pulls the trigger
        }//ends for
        z.speed(f);
        wait(0.085);//continue motor small amount
        z.speed(0);
    }//if
    
    else if (w >= 9) {//if, high five
    
    
    
   
        for (hpos =0.0; hpos<=40.0; hpos=hpos+10.0) {
            hmyservo=(hpos/90.0);
            wait (0.07);
            printf("%f\n",hpos);
        }//for
        wait(1.0); //shows the hand
        for (hpos =40.0; hpos>=60.0; hpos=hpos+10.0) {
            hmyservo=(hpos/90.0);
            wait (0.07);
            printf("%f\n",hpos);
        }//for
        wait (1.0); // moves hand forward to hit users hand
        for (hpos =60.0; hpos>=0.0; hpos=hpos-10.0) {
            hmyservo=(hpos/90.0);
            wait (0.07);
            printf("%f\n",hpos);
        }//for
    
    
   }//end high five if
} //main
