/*
ES200 3321 Project 2 
MIDN 3/C Dietrich, Schwind, Silver
*/

#include "mbed.h"
#include "rtos.h"
#include "stdlib.h"
#include "Motor.h"
#include "Servo.h"

// global hardware objects
Serial pc(USBTX,USBRX); 

Servo servo_1(p24);//rotates hand between palm facing up and palm facing in
Servo servo_2(p21); //on jar to rotate it in hand
Motor motor(p29, p30, p26); // drive arm from 90 degrees to forehead
DigitalIn switch_1(p17); //on protoboard - hit to start 
DigitalIn switch_2(p18); //on "hand" - hits forehead to turn motor off
DigitalIn switch_3(p12); //on protoboard - returns arm to start position
DigitalIn switch_4(p10); //on "hand" - hits desk when going down to turn motor off



int main() {
    // setup
    pc.printf("ES200 3321 Team Peanut Butter Beat Army\r\n");
    servo_1.calibrate(0.0009, 45.0); //Calibrates the servo_1 timing by setting the pulse width and range of motion (45*2 = 90 degrees)
    servo_2.calibrate(0.0009, 90.0); //Calibrates the servo_2 timing by setting the pulse width and range of motion (45*2 = 90 degrees)
    
    // state machines start here
    while(1){
        
        // idle state
        do {
            pc.printf("main() in idle state, awaiting sw1\r\n");
            servo_1.write(0.25); //Sets the servo in the initial position - palm facing in
            servo_2.write(0.0); //Sets the servo in the initial position - Does not matter where
            ThisThread::sleep_for(200); 
        } while (!switch_1.read());
            
        // peanut butter rotation 
        pc.printf("main() in peanut butter rotation state LATER\r\n");
        
        
        // palm up state
        pc.printf("main() going to palm up state\r\n");
        servo_1.write(.75); //turn the hand to the "palm up" position
        ThisThread::sleep_for(2000);           //wait for hand to get into "palm up" position
        
        // smash state
        pc.printf("main() smash PB against head state\r\n");
        motor.speed(0.7);    //turn motor on to drive arm up
        while (!switch_2.read()){
            pc.printf("main() awaiting palm switch 2 to finish PB head smash\r\n");
            ThisThread::sleep_for(100); 
            }
        motor.speed(0.0); 
            
        // play sound
        pc.printf("main() in play sound state LATER\r\n");
        while (!switch_3.read()){
              pc.printf("main() awaiting switch_3 to recycle\r\n");
              ThisThread::sleep_for(200); 
              }; 
              
        // lower arm
        pc.printf("main() lowering arm\r\n"); 
        motor.speed(-0.5); //turns the motor on to return the arm to the original position      
        while (!switch_4.read()) {
            pc.printf("main() awaiting switch_4 during recycle\r\n"); 
            ThisThread::sleep_for(200);
        } 
        motor.speed(0.0); // motor will turn off
        ThisThread::sleep_for(1000);        //wait 1 second for arm to level out
        
        // palm to side
        pc.printf("main() palm to side position\r\n");
        servo_1.write(0.25); //Servo 1 will turn on returning the hand to the original "palm in" position
                
        pc.printf("main() returning to idle state\r\n");
        } // while(1)
} // main()















if (switch_1.read() == 1) //User hits switch 1 (button on protoboard)
{



/*
{motor.speed(0);   //turn motor off
int a = rand()%1;} //Generate random integer 0 or 1 to determine if the jar will open or not - what sound will play and if jar opens

if (a == 1) {
    servo_1.write(...); //Servo on wrist turns to allow pb to come out
    pc.printf("1\n"); // send signal to Matlab to play Beat Army sound
    wait(10.0); // wait for Matlab to finish playing the sound NATHAN'S CODE???
      
else if (a == 0)
{
    pc.printf("2\n"); // send signal to Matlab to play boo sound
    wait(10.0); // wait for Matlab to finish playing the sound NATHAN'S CODE???
}
*/

