/*
ES200 Project 2 thread use
Rock em Sock em 2018
Note that this uses mbed OS 5 vice OS 2. 
*/

#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "Motor.h"
#include "Servo.h"

// Declare some stuff
DigitalIn sw1(p17); // switch for activating led5
DigitalIn sw2(p16); // switch for activating servo 
DigitalIn sw3(p20); // switch for activating servo2
DigitalIn sw4(p19); // switch for led4
DigitalOut led1(p5); // status LED for motor
DigitalOut led2(p6); // status LED for sw2
DigitalOut led3(p7); // status LED for sw3
DigitalOut led4(p8); // status LED for sw4
DigitalOut led5(p11); //status LED for sw1
DigitalOut heartbeat(LED4); // heartbeat LED adds visual effects
Motor m(p26,p30,p29); 
Servo s1(p21);
Servo s2(p22);
Thread m_thread; // NEW IN mbed OS 5, threads are used to (sorta) do multiple things at once
Thread s1_thread; //creates thread for servo
Thread s2_thread; // creates thread for servo2

/** Callback for executing a simple motor action. When sw1 is high,
 *  the motor turns forward, otherwise the motor turns off.
 */
void m_callback(void); // This function will be run within the corresponding thread

/** Simple callback for servo motion. When sw2 is high, the servo steps right,
 *  otherwise it steps left. If it hits the ends it stays there.
 */
void s1_callback(void);

void s2_callback(void);

// main() runs in its own thread in the OS
int main() {
    // startup things
    printf("ES200 Project 2 Rockem Sockem\n");
    s1.calibrate(0.0009,90.0); // calibrate servo s1 once at startup
    s2.calibrate(0.0009,90.0); //calibrate servo s2 once at startup
    m.speed(0.0); // set motor speed to zero at startup
    
    // start tasks
    printf("In the left corner: MIDN Slappy weighing 0.02 lbs.\n In the right corner: MIDN Hitme weighing 0.021 lbs.\n");
    m_thread.start(callback(m_callback)); // starts the motor thread going
    s1_thread.start(callback(s1_callback)); // starts the servo thread going
    s2_thread.start(callback(s2_callback)); //starts the servo2 thread going
    printf("\"ding ding ding\" Fight!\n");
    
    // main loop
    while(1){
        heartbeat = !heartbeat; // blink heartbeat once a second
        //ThisThread::sleep_for(1000);
        Thread::wait(500+rand()%1000);
                
        // motor or servo stuff not needed here because they are
        // running in their own threads. 
        } // main loop
} // main()




void m_callback(void){
    printf("THE fighters are moving back and forth like dancers!!\n");
    while(1) {
        
            led1.write(1); // light a light for entertaining purposes
            m.speed(-0.45); // spin motor ahead to move players together
            wait (0.65); //time of motor movement
            m.speed(0.0); //stop players when they are close.
            wait (3+rand()%5); //let them fight for a random amount of time
            led1.write(0); 
            m.speed(0.45); // move the players back
            wait (1.5); //time of opposite motor movement
            
            if (sw4.read()) {
                led4.write(1);
                }
            if (sw1.read()) {
                led5.write(1);
                }
                
        //ThisThread::sleep_for(200); // this thread executes 100x a second
        Thread::wait(50); //possibly change to small or erase
    } // while(1)
} // m_callback()
    
    
    
void s1_callback(void){
    printf("Slappy threw a punch!\n");    
    while(1){
        if (sw2.read()){
            led2.write(1); // light a light for entertaining purposes
            s1.write(s1.read()+0.5); // move servo a step to right
            }
            else{
                led2.write(0); 
                s1.write(0.0); // move servo a step to left
                }
        //ThisThread::sleep_for(200); // this thread executes 100x a second
        Thread::wait(50); //Not used so that switches move players immediately - - - may have to use so that switches can move independently
        } // while(1)
} // s1_callback()

void s2_callback(void){
    printf("Hitme is fighting back!\n");    
    while(1){
        if (sw3.read()){
            led3.write(1); // light a light for entertaining purposes
            s2.write(s2.read()+0.5); // move servo a step to right
            }
            else{
                led3.write(0); 
                s2.write(0.0); // move servo a step to left
                }
        //ThisThread::sleep_for(200); // this thread executes 100x a second
        Thread::wait(50); //possibly change
        } // while(1)
} // s2_callback()
