#include "StaticDefs.hpp"

//Declare static global variables using 'construct on use' idiom to ensure they are always constructed correctly
// and avoid "static initialization order fiasco".

Timer &systemTime()
{
    static Timer s;
    return s;
}

Serial & pc()
{
    //static MODSERIAL p(USBTX, USBRX, 512, 64); // tx, rx
    static Serial p(USBTX, USBRX);
    return p;
}

SpiADC & adc()
{
    static SpiADC adc;
    return adc;
}

PosVelFilter  &   pvf()
{
    static PosVelFilter pvf;
    return pvf;
}

PololuHBridge & hBridge()
{
    static PololuHBridge hBridge(p25, p29, p30);
    return hBridge;
}


PololuHBridge & la_hBridge()
{
    static PololuHBridge la_hBridge(p23, p21, p22);
    return la_hBridge;
}


PositionController & posCon()
{
    static PositionController posCon;
    return posCon;
}
