/*
 This program read temperature using two LM35 
 sensors on A0 and A1 analog inputs and displays 
 average temperature using serial
 Also, if the temp is in the range (18,22) C then 
 the green led is on, if the temp is in the range 
 (16,18) and (22,24) C the blue led is on, else 
 red led will be on.
 You can see the connection diagram on my blog
 sdizdarevic.com soon
*/
 

#include "mbed.h"
DigitalOut red(LED_RED);                 // Red led
DigitalOut blue(LED_BLUE); //blue led
DigitalOut green(LED_GREEN); // green LED
AnalogIn T1(PTB2); //  temperature  sensor T1 on A0
AnalogIn T2(PTB3); // temperature  sensor T2 on A1
float T; // average temperature
float tempF; //average temperature in Fahrenheit
float K=3.3*100; // scaling coefficient for calculating 
 // analog value to temperature
 
 Serial pc(USBTX,USBRX); // print temperature on console (eg. Putty)
 
 
int main() {
 pc.printf("LM35 temperature sensor\n");

 while(1) {
 red=0;//red=0;
 blue=0; //blue=0;
 green=0; //green=0;
 T=(T1+T1)/2.*K; // average temperature value in Celsius (C)
 
  
tempF=(9.0*T)/5.0 + 32.0; //average temperature value in fahrenheit (F)

 
 
 wait(0.2f); //wait a little
 pc.printf("Temperature (in Celsius) is %4.2f \r\n",T);
 
 
 wait(0.2f); //wait a little
 pc.printf("Temperature (in Fahrenheit) is %4.2f \r\n",tempF);
 
 
 if ( T>=18 && T<=22 ) green=1;
 else if ((T>=16 && T<18)||(T>22 && T<=24)) blue=1;
 else red=1;
 wait(0.2);
 
 }
}