#ifndef E_HELPER_H
#define E_HELPER_H
bool IsNum (const char C) 
{
    return (C >= '0' && C <= '9'); 
}
char ToUpper (const char C) 
{ 
    if (C >= 'a' && C <= 'z') 
        return C - 32; 
    return C;
}
bool IsOurChar (const char C) 
{
    char c = ToUpper (C); 
    return c == 'B' || c == 'R' || c == 'P' || c == 'Z' || c == 'H'; 
}
int ToInt (const char C[]) 
{
    int N = 0, i = 0;       
    while (C[i] != '\0') 
    {
        if (IsNum (C[i])) 
        {
            N = N * 10 + C[i++] - '0'; 
        }
        else return -7;  
    }
    return N;
}
int NumLen (int N)
{
    if (N == 0) return 1;
    int C = 0;
    while (N != 0) 
        {
            C++;
            N /= 10;
        }
    return C;
}
char *ToString (char Buff[], int N)
{
    if (N==0) 
    {
        Buff[0] = '0';
        Buff[1] = '\0'; 
        return Buff;
    }
    int B = NumLen (N);
    Buff[B] = '\0';
    while (N != 0) 
    {
        Buff[--B] = N % 10 + '0';
        N /= 10;
    }
    return Buff;
}
#endif  //E_HELPER_H
