#include "mbed.h"
#include "Snakelib.h"
#include "Helper.h"
Serial PC (USBTX, USBRX);
Ticker T;

//Very important to connect! Snakelib class parametters from N5110 lcd (VCC,SCE, RST,D/C, MOSI,SCLK,LED) and the last 3 from joystick

Snakelib Snake (PTB2, PTD0, PTB9, PTB3, PTD2, PTD1, PTD0, PTB11, PTC11, PTC10);
void Start()
    {
        if (!PC.readable()) return;
                char C = PC.getc();
        while (!IsOurChar (C)) C = PC.getc();
        C = ToUpper (C);
        static char Buff[4] = "000"; 
        if (C == 'B' || C == 'Z' || C == 'H') 
            {
                int N = -7;
                if (C == 'B') //B01 - B10
                    {
                        Buff[0] = PC.getc();
                        Buff[1] = PC.getc();
                        N = ToInt (Buff);
                        if (N == -7) return;
                        Snake.SetSnakeSpeed (N);
                        PC.printf ("\nSnake speed changed to %d\n", N);
                        return;
                    }
                Buff[0] = PC.getc();
                Buff[1] = 0;
                if ((N = ToInt (Buff)) == -7) return;
                if (C == 'Z') {Snake.SetSnakeType (N); PC.printf ("\nSnake type changed to %d\n", N);}
                else {Snake.SetFoodType (N); PC.printf ("\nSnake food changed to %d\n", N);}
            }
        else if (C == 'P') 
            {
                if (Snake.Paused()) Snake.ResumeGame(), PC.printf ("\nContinuing...\n");
                else Snake.PauseGame(), PC.printf ("\nPause...\n");
            }
        else if (C == 'R') Snake.Restart(), PC.printf ("\nRestarted!\n");
    }
int main ()
    {
        
        PC.printf ("\nManual:\n\n-P -> Pause/Continue\n-Z# -> Change snake type. Allowed values Z1-Z6\n");
        PC.printf ("-H# -> Change snake food. Allowed values H1-H5\n-R -> Restart game\n");
        PC.printf ("-B# -> Change snake speed. Allowed B01-B10\n");
        PC.printf ("\nTemp settings: B6, Z1, H1\nTo start playing, use joystick.\n\n \n\n");
        T.attach (&Start, 0.01);
        Snake.START();
        while (7);
    }
