#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

DigitalOut ledr(PTB22);
DigitalOut ledg(PTE26);
DigitalOut ledb(PTB21);
DigitalIn sw(PTA4);

int main() {
    int res;
    char buf[100];
    char msg[100];
    ledg = 1;
    ledr = 1;
    ledb = 1;
    bool pb = 1;
    
    printf("START\r\n");
    EthernetInterface eth;
    eth.init();
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    wait(1.0);
    
    // Change YOURLOGIN for your mbed login so you can communicate to the board
    // using the mbed websocket at:
    // http://sockets.mbed.org/YOURLOGIN
    Websocket ws("ws://sockets.mbed.org/ws/YOURLOGIN/ro");
    ws.connect();
    
    while (pb) {
        if(!ws.read(buf)) {
            if(buf[0] == 'r') {
                if(buf[1] == '0') {
                    ledr = 0;
                } else {
                    ledr = 1;
                }
            }
            if(buf[0] == 'g') {
                if(buf[1] == '0') {
                    ledg = 0;
                } else {
                    ledg = 1;
                }
            }
            if(buf[0] == 'b') {
                if(buf[1] == '0') {
                    ledb = 0;
                } else {
                    ledb = 1;
                }
            }
        }
        pb = sw;
    }
    ws.close();
    eth.disconnect();
    ledg = 1;
    ledr = 1;
    ledb = 1;
    while(1) {
    }
}
