
#include "mbed.h"           
#include "RA8875.h"         
#include "Keypad.h"

#include "MyFont18x32.h"
#include "BPG_Arial08x08.h"
#include "BPG_Arial10x10.h"
#include "BPG_Arial20x20.h"
#include "BPG_Arial31x32.h"
#include "BPG_Arial63x63.h"

#include "SDFileSystem.h" 
#include "FATFileSystem.h" 



//LocalFileSystem local("local");     // Because I want <PrintScreen>
// Localfile system is not avail on K64F, but SD card is.
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

Serial pc(USBTX, USBRX);            // And a little feedback

RA8875 lcd(PTD2, PTD3, PTD1, PTD0, NC, "tft");    // MOSI, MISO, SCK, /ChipSelect, /reset, name
Keypad kp(lcd);                                  // Associate Virtual keypad with the RA8875 TFT


void CalibrateTS(void)
{
    FILE * fh;
    tpMatrix_t matrix;
    RetCode_t r;
 
    r = lcd.TouchPanelCalibrate("Calibrate the touch panel", &matrix);
    if (r == noerror) {
        fh = fopen("/sd/tpcal.cfg", "wb");
        if (fh) {
            fwrite(&matrix, sizeof(tpMatrix_t), 1, fh);
            fclose(fh);
        } else {
        }
    } else {
    }
}
 
 
void InitTS(void)
{
    FILE * fh;
    tpMatrix_t matrix;
 
    fh = fopen("/sd/tpcal.cfg", "rb");
    if (fh) {
        fread(&matrix, sizeof(tpMatrix_t), 1, fh);
        fclose(fh);
        lcd.TouchPanelSetMatrix(&matrix);
        pc.printf("Touch Panel calibration set\r\n");
    } else {
        CalibrateTS();
    }
}
 

int main()
{
    char name1[20], name2[20];
 
    pc.baud(115200);                            
    pc.printf("\r\nDev Keypad - Build " __DATE__ " " __TIME__ "\r\n");
 
    lcd.init();
    lcd.foreground(Yellow);
    lcd.background(Black);
    lcd.puts(0,0, "RA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");
    InitTS();
    while(1) {
        lcd.foreground(Yellow);
        lcd.background(Black);
        lcd.cls();
        lcd.puts(0,20, "Enter username and password\r\n");
        if (kp.GetString(name1, 20, "Username:")) {
     pc.printf("PrintScreen activated ...\r\n");
    RetCode_t r = lcd.PrintScreen(0,0,480,272,"/sd/file2.bmp");
    pc.printf("  PrintScreen returned %d\r\n", r);
            lcd.printf("username: %s\r\n", name1);
             if (kp.GetString(name2, 20, "Password:", '*')) {
                lcd.printf("password: %s\r\n", name2);
                kp.Erase();
                lcd.foreground(BrightRed);
                lcd.background(Black);
                lcd.cls();
                lcd.SetTextFontSize(2);
                lcd.SetTextCursor(0,30);
                lcd.printf("username: %s\r\npassword: %s\r\n", name1, name2);
                lcd.SetTextFontSize();
                
               
            }
        } else {
            kp.Erase();
            pc.printf("<esc>\r\n");
        }
        wait(5);
    }
}
 