
#include "mbed.h"           // v112
#include "RA8875.h"         // v102
#include "MyFont18x32.h"
#include "BPG_Arial08x08.h"
#include "BPG_Arial10x10.h"
#include "BPG_Arial20x20.h"
#include "BPG_Arial31x32.h"
#include "BPG_Arial63x63.h"

#include "SDFileSystem.h" 
#include "FATFileSystem.h" 



//LocalFileSystem local("local");     // Because I want <PrintScreen>
// Localfile system is not avail on K64F, but SD card is.
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

Serial pc(USBTX, USBRX);            // And a little feedback

int main()
{
//    RA8875 lcd(p5, p6, p7, p12, NC, "tft");    // MOSI, MISO, SCK, /ChipSelect, /reset, name
RA8875 lcd(PTD2, PTD3, PTD1, PTD0, NC, "tft");    // MOSI, MISO, SCK, /ChipSelect, /reset, name
    
   pc.baud(115200);    
   pc.printf("\r\nRA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    lcd.init();
    
    
    // **************************
    //RunTestSet(lcd, pc);  // If the library was compiled for test mode...
    
    lcd.foreground(RGB(255,255,0));
    lcd.puts(0,0, "RA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    lcd.SelectUserFont(Dave_Smart18x32);
    lcd.puts("**** ! Soft Fonts ! **** 0123456789\r\n");
    lcd.puts("ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont();
    lcd.puts("Back to normal\r\n");
    lcd.SelectUserFont(BPG_Arial08x08);
    lcd.puts("BPG_Arial08x08 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial08x08 abcdefghijklmnopqrstuvwxyz\r\n");    
    lcd.SelectUserFont(BPG_Arial10x10);
    lcd.puts("BPG_Arial10x10 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial10x10 abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont(BPG_Arial20x20);
    lcd.puts("BPG_Arial20x20  ");
    lcd.SelectUserFont(BPG_Arial31x32);
    lcd.puts("BPG_Arial31x32\r\n");
    lcd.SelectUserFont(BPG_Arial63x63);
    lcd.puts("BPG_Arial63x63");

    pc.printf("PrintScreen activated ...\r\n");
    RetCode_t r = lcd.PrintScreen(0,0,480,272,"/sd/file.bmp");
    pc.printf("  PrintScreen returned %d\r\n", r);
    
    while(1) {
        ;       // end
    }
}
