#include "mbed.h"
#include "beep.h"

Serial PC(USBTX, USBRX);

//Sensor
InterruptIn pir(D5);

//Buttons
InterruptIn on(D7);
InterruptIn off(D6);

//Buzzer
Beep buzzer(D9);

int flagOn,flagOff,flagPIR=0;
int i = 0;
int alarmOn=0;  //State (on/off)

void  onInterrupt() 
{
    flagOn=1;
}

void  offInterrupt()
{
    flagOff=1;
}

void pirInterrupt()
{
    flagPIR=1;
}

int main()
{
    // on/off interrupts init          
    on.rise(&onInterrupt);
    off.rise(&offInterrupt);    
    
    // pir sensor interrupt init
    pir.rise(&pirInterrupt);
    
    // start
    PC.printf("Working... ");
    while (1) {
        if (flagOn) {
            PC.printf("Alarm on ");
            alarmOn=1;
            flagOn = 0; //clear flag
        }
        
        if (flagOff) {
            PC.printf("Alarm off ");
            alarmOn=0;
            buzzer.beep(0,0); //Frec(Hz),Time(Sec)
            flagOff = 0; //clear flag
        }

        if (flagPIR) {
            if (alarmOn){
                buzzer.beep(1000,10); //Frec(Hz),Time(Sec)
            }
            flagPIR=0;  //clear flag
        }
        __wfi(); //waiting for interrupt 
    }
}