#include "mbed.h"
#include "rtos.h"


double *A,*B,*C;
int i,j,k,N;
Serial pc(USBTX, USBRX); // tx, rx

void process1_thread(void const *args)
{
    for(i=0; i<N/2; i++) {
        for(j=0; j<N; j++) {
            C[i*N+j]=0;
            for(k=0; k<N; k++) {
                C[i*N+j]= C[i*N+j] + A[i*N+k]*B[k+j*N];
            }
        }
    }
}

void process2_thread(void const *args)
{
    for(i=N/2; i<N; i++) {
        for(j=0; j<N; j++) {
            C[i*N+j]=0;
            for(k=0; k<N; k++) {
                C[i*N+j]= C[i*N+j] + A[i*N+k]*B[k+j*N];
            }
        }
    }
}


int main()
{
    
    N=10;
    //Inicialize matrix
    for(i=0; i<N; i++) {
        for(j=0; j<N; j++) {
            A[i*N+j]=1;
            B[i+j*N]=1;
        }
    }
    
    Thread thread1(process1_thread);
    Thread thread2(process2_thread);
    
    //Print Results
    for (i=0;i<N;i++){
        for(j=0;j<N;j++){
            pc.printf("%d ",C[i*N+j]); 
        }
         pc.printf("\n");
    }  
}