#include "mbed.h"

Serial blue(D1,D0);     //(TX,DX)
Serial PC(USBTX, USBRX);    // Used to debug
Ticker timer;

//Home lights
DigitalOut ledBedroom(D9);
DigitalOut ledLiving(D10);
DigitalOut ledGarden(D11);

//
DigitalOut fan(D12);    

//Sensors
AnalogIn temp(A0);
AnalogIn light(A1);

float tempRead,lightRead=0; 
int flagBlue,flagTimer=0;   //Interrupts flags
int manual=0;   //to handle the ledGarden and the fan manually

char c;

void timerInterrupt()
{
    flagTimer=1;
}

void blueInterrupt()
{
    c = blue.getc(); //receives the command
    flagBlue=1;
}

int main()
{
    //Bluetooth init
    blue.baud(9600);
    blue.attach(&blueInterrupt);
    //Timer init
    timer.attach(&timerInterrupt, 1.0); //time interval 1 sec
    while (1) {
        if (flagTimer) {
            tempRead = temp.read() * 333.333;   //value in celsius
            lightRead=light.read(); //value between 0 - 1
            if (manual==0) {    //automatic mode
                if (lightRead<0.2)  
                    ledGarden=1;    //The ledGarden turns on at night 
                else
                    ledGarden=0;    //The ledGarden turns off during the day
                if (tempRead>30)    
                    fan=1;  //The fan turns on if it's hot
                else
                    fan=0;
            }
            flagTimer=0;    //clear flag
        } //End flagTimer

        if (flagBlue) {
            switch(c) {
                case 'b':   //bedroom
                    ledBedroom=!ledBedroom;
                    break;
                case 'l':   //living room
                    ledLiving=!ledLiving;
                    break;
                case 'g':   //garden
                    ledGarden = !ledGarden;
                    break;
                case 'f':   //fan
                    fan=!fan;
                    break;
                case 'm':   //to activate manual/automatic mode
                    if(manual)
                        manual=0;   //automatic mode
                    else
                        manual=1;   //manual mode
                    break;
                default:
                    break;
            }
            flagBlue=0;
        }   //End flagBlue

        __wfi(); //waiting for interrupt 
    }
}