#include "mbed.h"
#include <string>
#include <Ticker.h>


Ticker cronTimer;

DigitalOut segH(D15);
DigitalOut segG(D14);
DigitalOut segF(D13);
DigitalOut segE(D12);
DigitalOut segD(D11);
DigitalOut segC(D10);
DigitalOut segB(D9);
DigitalOut segA(D7);
DigitalOut dig1(D1);
DigitalOut dig2(D2);
DigitalOut dig3(D3);
DigitalOut dig4(D4);

unsigned char flagUART=0;
unsigned char flagCronTimer=0;
unsigned char running=0;
unsigned int centCron=0;
unsigned int segCron=0;
unsigned int segCronDec=0;
unsigned int segCronUni=0;
unsigned int centCronDec=0;
unsigned int centCronUni=0;
int received;


Serial pc(USBTX, USBRX);

void writeDigit(int n) 
{

    switch (n) {


        case 0:
            segG=segH=1;

            segA=segB=segC=segD=segE=segF=0;  //LEDS ARE ACTIVE-LOW
            break;
        case 1:
            segA=segD=segE=segF=segG=segH=1;
            segB=segC=0;
            break;
        case 2:
            segC=segF=segH=1;
            segA=segB=segD=segE=segG=0;
            break;
        case 3:
            segE=segF=segH=1;
            segA=segB=segC=segD=segG=0;
            break;
        case 4:
            segA=segD=segE=segH=1;
            segB=segC=segF=segG=0;

            break;
        case 5:
            segB=segE=segH=1;
            segA=segC=segD=segF=segG=0;

            break;
        case 6:
            segB=segH=1;
            segA=segC=segD=segE=segF=segG=0;
            break;
        case 7:
            segD=segE=segF=segG=segH=1;
            segA=segB=segC=0;

            break;
        case 8:
            segH=1;
            segA=segB=segC=segD=segE=segF=segG=0;
            break;
        case 9:

            segD=segE=segH=1;
            segA=segB=segC=segF=segG=0;
            break;

    }

}

void updateDisplay(int d1,int d2, int d3, int d4) 
{


    dig2=dig3=dig4=1;
    dig1=0;
    writeDigit(d1);
    wait_ms(1.5);

    dig1=dig3=dig4=1;
    dig2=segH=0;
    writeDigit(d2);
    wait_ms(1.5);

    dig1=dig2=dig4=1;
    dig3=0;
   writeDigit(d3);
    wait_ms(1.5);

    dig1=dig2=dig3=1;
    dig4=0;
   writeDigit(d4);
    wait_ms(1.5);
}

void serialInterruptHandler()
{
    string s;
    s=pc.getc();
    received= atoi(s.c_str());
    flagUART=1;
}

void cronTimerInterruptHandler()
{
    flagCronTimer=1;
}

int main()
{
    pc.attach(&serialInterruptHandler);

    while(1) {

        if (flagUART) { 

                    if(received==1) {    //start             
                        if(running==0) { 

                            if((segCron!=59) && (centCron!=99)) {
                                running=1;
                                cronTimer.attach_us(&cronTimerInterruptHandler,10000);//each 10ms
                                pc.printf("RUNNING\n");
                                }
                        }
                        else
                            pc.printf("ALREADY RUNNING\n");
                      flagUART=0;
                    }

                    if(received==2) { //pause

                        if (running==1) { 
                            cronTimer.detach();
                            if(segCron!=59) 
                                running=0;
                            pc.printf("PAUSED\n");
                        } 
                        else 
                            pc.printf("NOT RUNNING\n");
                         flagUART=0;
                
                    }

                    if(received==3) { //reset
                            cronTimer.detach();
                            segCron=0;
                            centCron=0;
                            segCronDec=0;
                            segCronUni=0;
                            centCronDec=0;
                            centCronUni=0;
                            running=0;
                            pc.printf("RESET\n");
                            flagUART=0;

                        }


         

            }


        if(flagCronTimer) {  

            if(running) { 

                centCron++;

                if (centCron == 100) {  
                    segCron++;
                    centCron=0;
                }

                if ((segCron==59) & (centCron==99)) { //TURN OFF CHRONOMETER AT  59.99 SECS
                    running=0;
                    cronTimer.detach();


                }
            }

//SPLIT NUMBER INTO DIGITS

            segCronDec=segCron/10;
            segCronUni=segCron%10;
            centCronDec=centCron/10;
            centCronUni=centCron %10;

            //CLEAR FLAG
            flagCronTimer=0;
        }

          updateDisplay(segCronDec,segCronUni,centCronDec,centCronUni);
    }
}