/* Display library for Adafruit 358 TFT display written for the FRDM-K64F
 * 
 * Copyright (c) 2014 Brian Mazzeo
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * This 1.8" display has 128x160 color pixels
 */

#ifndef ADAFRUIT_358_H
#define ADAFRUIT_358_H

#include "mbed.h"
#include "GraphicsDisplay.h"

// These controls are very useful and retrived from Paul's Adafruit_ST7735.h library
#define ST7735_TFTWIDTH  128
#define ST7735_TFTHEIGHT 160

#define ST7735_NOP     0x00
#define ST7735_SWRESET 0x01
#define ST7735_RDDID   0x04
#define ST7735_RDDST   0x09

#define ST7735_SLPIN   0x10
#define ST7735_SLPOUT  0x11
#define ST7735_PTLON   0x12
#define ST7735_NORON   0x13

#define ST7735_INVOFF  0x20
#define ST7735_INVON   0x21
#define ST7735_DISPOFF 0x28
#define ST7735_DISPON  0x29
#define ST7735_CASET   0x2A
#define ST7735_RASET   0x2B
#define ST7735_RAMWR   0x2C
#define ST7735_RAMRD   0x2E

#define ST7735_PTLAR   0x30
#define ST7735_COLMOD  0x3A
#define ST7735_MADCTL  0x36

#define ST7735_FRMCTR1 0xB1
#define ST7735_FRMCTR2 0xB2
#define ST7735_FRMCTR3 0xB3
#define ST7735_INVCTR  0xB4
#define ST7735_DISSET5 0xB6

#define ST7735_PWCTR1  0xC0
#define ST7735_PWCTR2  0xC1
#define ST7735_PWCTR3  0xC2
#define ST7735_PWCTR4  0xC3
#define ST7735_PWCTR5  0xC4
#define ST7735_VMCTR1  0xC5

#define ST7735_RDID1   0xDA
#define ST7735_RDID2   0xDB
#define ST7735_RDID3   0xDC
#define ST7735_RDID4   0xDD

#define ST7735_PWCTR6  0xFC

#define ST7735_GMCTRP1 0xE0
#define ST7735_GMCTRN1 0xE1

// Color definitions
#define ST7735_BLACK   0x0000
#define ST7735_GREEN   0x07E0
#define ST7735_CYAN    0x07FF
#define ST7735_MAGENTA 0xF81F
#define ST7735_WHITE   0xFFFF
#define ST7735_BLUE     0xFFE0
#define ST7735_RED      0x001F
#define ST7735_YELLOW   0x07FF


class Adafruit_358 : public GraphicsDisplay {
 public:

  Adafruit_358(PinName MOSI, PinName MISO, PinName SCLK, PinName CS, PinName RESET, PinName DC, const char* name ="TFT");

  void      screen_reset(void);                             // for ST7735B displays
  void      wr_cmd(unsigned char cmd);
  void      fillrect(int x0, int y0, int x1, int y1, uint16_t color);
  
  virtual int       width(void);
  virtual int       height(void);
  virtual void      pixel(int x, int y, int color);
  
  virtual void      cls(void);
 
  void set_font(unsigned char* f);
  
  SPI _spi;
  DigitalOut _cs; 
  DigitalOut _reset;
  DigitalOut _dc;
  unsigned char* font;
 
 private:

  unsigned int char_x;
  unsigned int char_y;

  void WindowMax (void);
  
};
  
#endif