#ifndef DT35_TOR
#define DT35_TOR


#include "mbed.h"

#define PIN_CAP_G PB_1
#define PIN_CAP_D PC_5
#define PIN_CAP_A PC_4


#define V_min 0.64  //Tension (V) minimale prélevée sur la résistance
#define V_max 3.2   //Tension (V) maximale prélevée sur la résistance

#define D_min 50     //Distance (mm) minimale mesurée par le capteur
#define D_max 9000   //Distance (mm) maximale mesurée par le capteur

#define Nb_echantillon 5 //Nombre de valeurs utilisées pour le moyennage 

#define Correction 120 //Correction apportée sur la formule
#define Correction_Ar 80 //Correction apportée sur la formule

#define D_ROULEAU_AXE 200

#define Conv (V_max - V_min)/((V_max/3.3)-(V_min/3.3))

#define A (D_max - D_min)/(V_max - V_min)*Conv
#define B (D_max - ((D_max - D_min)/(V_max - V_min))*V_max) + Correction
#define B_A (D_max - ((D_max - D_min)/(V_max - V_min))*V_max) + Correction_Ar

#define ERROR_MAX 80
#define N_DIFF 5

//DT_35 :

extern float DTG_avg_Ex, DTD_avg_Ex,DTA_avg_Ex,DT_avg_Ex, DT_avg_min_Ex;
extern int derivg, derivd;
extern int balleg, balled, difGD;

void Detection_init(int active);
void moy();
void mediane();
void Detection_balle();
void f_mesure();
void Detection_init(void);
void tri(float* tab, int size);
#endif