#ifndef CAN_ASSER_H
#define CAN_ASSER_H

#include "mbed.h"
 
#define TE_100US 100
#define TE (TE_100US*0.0001) 
 
#define ASSERVISSEMENT_STOP 0x001  // Stop moteur
#define ASSERVISSEMENT_SPEED_DANGER 0x006  // Vitesse de danger
#define ASSERVISSEMENT_XYT 0x020  // Asservissement (x,y,theta)  (0 : au choix 1 : avant -1 : arrière)
#define ASSERVISSEMENT_COURBURE 0x021  // Asservissement rayon de courbure  (+ gauche, - droite , sens : 1avt , -1arr; enchainement => 1 oui, 0 => non, 2=>derniére instruction de l'enchainement)
#define ASSERVISSEMENT_CONFIG 0x022  // Asservissement paramètre  (définir les valeurs de vitesse max et d'eccélération max)
#define ASSERVISSEMENT_ROTATION 0x023  // Asservissement rotation
#define ASSERVISSEMENT_RECALAGE 0x024  // Moteur tout droit  (recalage : 0 mouvement seul, 1 x, 2y valeur : coordonnée à laquelle est recalé x/y; enchainement => 1 oui, 0 => non)
#define ASSERVISSEMENT_CONFIG_DECEL 0x019 

#define ASSERVISSEMENT_ENABLE 0x1F7  // Activation asservissement  (0 : désactivation, 1 : activation)

#define ASSERVISSEMENT_CONFIG_KPP_DROITE 0x1F1
#define ASSERVISSEMENT_CONFIG_KPI_DROITE 0x1F2
#define ASSERVISSEMENT_CONFIG_KPD_DROITE 0x1F3
#define ASSERVISSEMENT_CONFIG_KPP_GAUCHE 0x1F4
#define ASSERVISSEMENT_CONFIG_KPI_GAUCHE 0x1F5
#define ASSERVISSEMENT_CONFIG_KPD_GAUCHE 0x1F6

#define ODOMETRIE_POSITION 0x26

extern double KppD;
extern double KipD;
extern double KdpD;

extern double KppG;
extern double KipG;
extern double KdpG;

extern unsigned char pt_lecture_can, pt_ecriture_can; 
extern int nb_msg_can;
extern CANMessage msg_can[256];
extern short pos[3];
extern int flagFinDpl;

void isr_can(); 

void trait_can();
 
void can_init(void);

void get_pos(CANMessage msg_pos, short* position);

int compare_tab(short* t1, short* t2, int size);

void remonter_tab_can(CANMessage* tab, int taille);

void SendCoefK (unsigned short id, double K);

/*********************************************************************************************************/

/* FUNCTION NAME: SendRawId */
/* DESCRIPTION : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id);

/*********************************************************************************************/

/* FUNCTION NAME: SendAck */

/* DESCRIPTION : Envoyer un acknowledge */
/*********************************************************************************************/
void SendAck(unsigned short id, unsigned short from);

/*********************************************************************************************/

/* FUNCTION NAME: GoToPosition */
/* DESCRIPTION : Transmission CAN correspondant à un asservissement en position (x,y,theta) */
/*********************************************************************************************/

void GoToPosition (unsigned short x,unsigned short y,signed short theta,signed char sens);

/****************************************************************************************/

/* FUNCTION NAME: Rotate */

/* DESCRIPTION : Transmission CAN correspondant à une rotation */
/****************************************************************************************/

void Rotate (signed short angle);

/********************************************************************************************
 FUNCTION NAME: GoStraight 
 DESCRIPTION : Transmission CAN correspondant à une ligne droite, avec ou sans recalage 

 recalage : 0 => pas de recalage 

 1 => recalage en X 

 2 => Recalage en Y 

 newValue : Uniquement en cas de recalage, indique la nouvelle valeur de l'odo 

 isEnchainement : Indique si il faut executer l'instruction en enchainement 

 0 => non 

 1 => oui 
 
2 => dernière instruction de l'enchainement 
 ********************************************************************************************/
void GoStraight (signed short distance,unsigned char recalage, unsigned short newValue, unsigned char isEnchainement);

/********************************************************************************************/

/* FUNCTION NAME: BendRadius */

/* DESCRIPTION : Transmission CAN correspondant à un rayon de courbure */
/********************************************************************************************/
void BendRadius (unsigned short rayon,signed short angle,signed char sens, unsigned char enchainement);

void SetOdometrie (unsigned short canId, unsigned short x,unsigned short y,signed short theta);

/****************************************************************************************/

/* FUNCTION NAME: setAsservissementEtat */

/* DESCRIPTION : Activer ou désactiver l'asservissement */
/****************************************************************************************/
void setAsservissementEtat(unsigned char enable);

/****************************************************************************************/

/* FUNCTION NAME: SendSpeed */

/* DESCRIPTION : Envoie un asservissement paramètre retournant à une vitesse */
/****************************************************************************************/
void SendSpeed (unsigned short vitesse, unsigned short acceleration);
/****************************************************************************************/

/* FUNCTION NAME: SendSpeedDecel */

/* DESCRIPTION : Envoie un asservissement paramètre retournant à une vitesse */
/****************************************************************************************/
void SendSpeedDecel (unsigned short vitesse, unsigned short deceleration);


#endif