#include "mbed.h"
#include "VMA306.h"

Serial      pc          (PA_2, PA_3, 921600);                                                       // Create a serial link to PC for communication

VMA306      UltraSon    (PB_15, PA_6, PB_14, PC_7, PB_13, PB_2);                                    // Create 3 ultrasonic sensors (1 and 2 sensor support will be added)

DigitalOut  led1        (PA_5);                                                                     // Added Led1 for test purpose
DigitalOut  led2        (PD_2);                                                                     // Added Led2 for test purpose
DigitalOut  disquette   (PA_12);                                                                    // Added baloon destructor command (without it, you might see baloon destructor motor be set to full speed)

int main()
{
    led1 = 1;                                                                                       // Led1 switch ON
    led2 = 0;                                                                                       // Led2 switch OFF
    disquette = 0;                                                                                  // Baloon destructor switch OFF

    while(1) {
        if (UltraSon.isUSGReady())      pc.printf ("\rusG = %5.2lf -", UltraSon.readUSG());         // If left ultra sonic seonsor has a mesurment print it  
        else                            pc.printf ("\r            -");                              // Else delete previous display of USG value
        if (UltraSon.isUSBReady())      pc.printf ("\r\t\t usB = %5.2lf -", UltraSon.readUSB());    // If back ultra sonic seonsor has a mesurment print it  
        else                            pc.printf ("\r\t\t            -");                          // Else delete previous display of USB value
        if (UltraSon.isUSDReady())      pc.printf ("\r\t\t\t\t usD = %5.2lf", UltraSon.readUSD());  // If right ultra sonic seonsor has a mesurment print it 
        else                            pc.printf ("\r\t\t\t\t            ");                       // Else delete previous display of USB value

        led1 = !led1;                                                                               // Switch Led1
        led2 = !led2;                                                                               // Switch Led2
    }
}
