#include "mbed.h"
#include "Pixy.h"

Serial      pc          (PA_2, PA_3, 921600);                   // Serial link with PC
PIXY        Pixy        (PA_0, PA_1, 230400);                   // The PIXY

DigitalOut  led1        (PA_5);                                 // Led1 is for test purpose
DigitalOut  led2        (PD_2);                                 // Led2 is for test purpose
DigitalOut  disquette   (PA_12);                                // Baloon destructor command signal (must be set to 0 if not used)

int main()
{
    int                 nbCC, nbNM, cr;                         // Local treatment variables
    Byte                msg, brightness = 50;                   
    T_pixyCCBloc        CCBuf;                                  // Color code object buffer
    T_pixyNMBloc        NMBuf;                                  // Normal object buffer

    pc.printf ("\r\nHelloWorld\r\n");                           // display "HelloWorld"
    led1 = 1;                                                   // Switch ON Led1
    led2 = 0;                                                   // Switch OFF Led2
    disquette = 0;                                              // Baloon destructor set to OFF

    wait (5);                                                   // Wait for PIXY to boot up
    if (Pixy.checkPixy() == -1) {                               // If no pixy is transmitting (neither pixy not teached or not connected or else)
        pc.printf ("\rNo Pixy\n\r");                            // display error message            
        while(1);                                               // Hang
    } else {                                                    // If pixy is talking
        pc.printf ("\rRock'n'Roll\n\r");                        // Let fun begin
    }
    
    do {
        Pixy.setBrightness (brightness);                        // Set brightness  (note that 0 brightness is ajustable in PIXYMON)
        wait (0.2);                                             // Wait for brightness to establish
        cr = Pixy.detectedObject (&nbNM, &nbCC);                // Read the number of objects detected
        pc.printf ("\r\nBrightness = %3d => nbCC = %2d - nbNM = %2d : cr = %2d ? ", brightness, nbCC, nbNM, cr);
        msg = pc.getc();                                        // Wait for user to choose what to do
        pc.printf("%c\r\n", msg);                               // Echo
        if (msg=='a') brightness += 5;                          // if message is 'a' then increase brightness by 5
        if (msg=='q') brightness -= 5;                          // if message is 'q' then decrease brightness by 5
        if (msg=='z') brightness += 1;                          // if message is 'z' then increase brightness by 1
        if (msg=='s') brightness -= 1;                          // if message is 's' then decrease brightness by 1
    } while (msg != 'X');                                       // Une 'X' to quit
        
    while (1) {
        if (Pixy.checkNewImage()) {                                             //Wait for new image
            cr = Pixy.detectedObject (&nbNM, &nbCC);                            // Get detected object list and display it
            pc.printf ("\r\tnbCC = %2d - nbNM = %2d : cr = %2d\n", nbCC, nbNM, cr);
            while (nbCC > 0) {                                                  // while there are some CC Blocks to read
                CCBuf = Pixy.getCCBloc ();                                      // Read them from FIFO and display them
                nbCC--;
                pc.printf ("\rCC %5d : x=%5d, y=%5d - w=%5d, h=%5d, a=%5d\n", CCBuf.signature, CCBuf.x, CCBuf.y, CCBuf.width, CCBuf.height, (short)CCBuf.angle);
            }
            while (nbNM > 0) {                                                  // while there are some NM Blocks to read
                NMBuf = Pixy.getNMBloc ();                                      // Read them from FIFO and display them
                nbNM--;
                pc.printf ("\rNM %4x : x=%5d, y=%5d - w=%5d, h=%5d\n", NMBuf.signature, NMBuf.x, NMBuf.y, NMBuf.width, NMBuf.height);
            }
            led1 = !led1;                                       // Switch Led1
            led2 = !led2;                                       // Switch Led2
        }
    }
}
