#ifndef SoftPWM_H
#define SoftPWM_H
#define POSITIVE true
#define NEGATIVE false

#include "mbed.h"

class SoftPWM  
{
private:
    Timeout _timeout;
    Ticker _ticker;
    void end();
    DigitalOut pulse;
    bool positive;
    void TickerInterrapt();
    double width;
    double interval;
public:
    SoftPWM(PinName,bool mode=true); 
//    void attach_us(int);
    void start();
    void write(double);
    double read();
    void pulsewidth(double);
    void pulsewidth_ms(int);
    void pulsewidth_us(int);
    void period(double);
    void period_ms(int);
    void period_us(int);
    void stop();
    operator double()  { 
        if ( width <= 0.0 ) return 0.0;
        if ( width > 1.0 )  return 1.0;
        return width / interval;
    }
    SoftPWM& operator=(double duty)  {
        width = interval * duty;
        if ( duty <= 0.0 ) width =  0.0f;
        if ( duty > 1.0 )  width =  interval;
        return *this;
    }
                
};
#endif