/**
 * @author Hugues Angelis
 *
 * @section LICENSE
 *
 * Copyright (c) 2010 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * VISHAY CNY70 Analog reflective sensor library
 *
 * @note this library provide a simple equivalent of the reading the voltage of
 *       an analog input.
 */

#ifndef CNY70_H
#define CNY70_H

/**
 * Includes : Mbed Library
 */
#include "mbed.h"

/**
 * CNY70 Optical Reflective Sensor.
 * More info : https://www.vishay.com/docs/83751/cny70.pdf 
 */
class CNY70 {

public :

    /**
     * Constructor of a CNY70 object.
     *
     * @param vmes : the Mbed pin used to connect with CNY70 sensor
     */
    CNY70(PinName vmes);

    /**
     * Return the voltage on the CNY70 output pin
     *
     * @return Voltage between 0 and 3.3V
     */
    double getVoltage (void);

    /**
     * Return the type of the ground (blue carpet or white stripe)
     *
     * @return 0 over a blue carpet, 1 over a PVC white stripe
     */
    int whatAmIOn (void);

    /** 
     * A short hand of getVoltage
     */
    operator double();
    

protected :

    AnalogIn    _sensor ;

};
#endif //CNY70_H