/**
 * @author Hugues Angelis, based on Aaron Berk
 *
 * @section LICENSE
 *
 * Copyright (c) 2010 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * CMPS03 digital compass module I2C.
 *
 * Datasheet:
 *
 * http://www.robot-electronics.co.uk/htm/cmps3tech.htm
 */

#ifndef CMPS03_H
#define CMPS03_H

/**
 * Includes : Mbed Library
 */
#include "mbed.h"

/**
 * CMPS03 digital compass module.
 * more information : http://www.robot-electronics.co.uk/htm/cmps3tech.htm
 */
class CMPS03 {

private :

    long    _startTime, _stopTime;
    double  _pwmBearing;

    InterruptIn _compass;
    Timer _tim;

    void rise();
    void fall();

public :

    /**
     * Constructor of a CMPS03 Compass object.
     *
     * @param pwm (PinName) : mbed pin used to get the bearing Pulse
     */
    CMPS03(PinName pwm);

    /**
     * Reads the last bearing of the compass from PWM signal (1 bearing each 100ms approx.).
     *
     * @return Current bearing of the compass in degree (0.00 and 359.99)
     * @note The bearing is not quite accurate (only integer part is almost good) unless a full calibration is done (thus component is not configurated for calibration).
     * @note Neither bearing goes from 0 to 359.99. You may considere bearing as something very relative.
     */
    double getBearing(void);

    /** 
     * A short hand for getBearing
     * @return Current bearing of the compass in degree (0.00 and 359.99)
     * @note The bearing is not quite accurate (only integer part is almost good) unless a full calibration is done (thus component is not configurated for calibration).
     * @note Neither bearing goes from 0 to 359.99. You may considere bearing as something very relative.
     */
    operator double();
    
};

#endif /* CMPS03_H */
