#include "mbed.h"

SPI DataPack(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut Latch(D10);
AnalogIn VR0(A0);
AnalogIn VR1(A1);
Serial pc(USBTX, USBRX);

int main()
{
    DataPack.frequency(100000);
    DataPack.format(8,0);

    float VR_value0,VR_value1;
    int Row[8]= {1,2,4,8,16,32,64,128};
    int Col[8]= {254,253,251,247,239,223,191,127};
    int x;

    while(1) {
        VR_value0 = VR0.read();
        VR_value1 = VR1.read();
        VR_value0 = VR_value0*6;
        VR_value1 = VR_value1*6;

        for(x=1; x<7; x++) {
            Latch=0;
            DataPack.write(Col[4]);
            wait_us(1);
            DataPack.write(0xFF);
            wait_us(1);
            DataPack.write(0xFF);
            wait_us(1);
            DataPack.write(Row[x]);
            wait_us(1);
            Latch=1;
            wait_ms(150);
        }
        
        for(x=5; x>1; x--) {
            Latch=0;
            DataPack.write(Col[4]);
            wait_us(1);
            DataPack.write(0xFF);
            wait_us(1);
            DataPack.write(0xFF);
            wait_us(1);
            DataPack.write(Row[x]);
            wait_us(1);
            Latch=1;
            wait_ms(150);
        }
    }
}
