#include "mbed.h"

Serial bluetooth(D8,D2);

AnalogIn VR(A0);
BusOut main_unit(D3,D4,D5,D6);
BusOut tens(D7,D9,D10,D11);


int main()
{
    int num_in,num_mem,menu,statemenu=0;
    char num_change[2];
    while(1) {
        if(statemenu==0) {
            bluetooth.printf("Main Menu\npush 1 to Play with number.\npush 2 to Read voltage from VR\n\n");
            statemenu=1;
        }
        menu = bluetooth.getc();
        switch(menu) {
            case '1':
                num_in=0;
                num_mem=0;
                bluetooth.printf("Please insert number from 00 to 99\n");
                num_change[0]=bluetooth.getc();
                num_change[1]=bluetooth.getc();
                num_in=atoi(num_change);
                num_mem=num_in%10;
                main_unit=num_mem;
                tens=(num_in-num_mem)/10;
                bluetooth.printf("Your number is %d\n\n",num_in);
                statemenu=0;
                break;
            case '2':
                bluetooth.printf("Your voltage is %f\n\n", VR.read()*3.3);
                statemenu=0;
                break;
            default :
                //bluetooth.printf("Please Insert Only 1 or 2.\n\n");
                statemenu=0;
                break;
        }
    }
}
