#include "mbed.h"

Serial bluetooth(D8,D2);

AnalogIn VR(A0);
BusOut main_unit(D3,D4,D5,D6);
BusOut tens(D7,D9,D10,D11);


int main()
{
    int num_in,num_mem;
    uint8_t menu;
    while(1) {
        bluetooth.printf("Main Menu\npush 1 to Play with number.\npush 2 to Read voltage from VR\n\n");
        menu = bluetooth.getc();
        switch(menu) {
            case '1':
                num_in=0;
                num_mem=0;
                bluetooth.printf("Please insert number from 0 to 99\n");
                bluetooth.scanf("%d/0" ,&num_in);
                num_mem=num_in%10;
                main_unit=num_mem;
                tens=(num_in-num_mem)/10;
                bluetooth.printf("Your number is %d\n\n",num_in);
                break;
            case '2':
                bluetooth.printf("Your voltage is %f\n\n", VR.read()*5);
                break;
        }
    }
}