#include "mbed.h"
#include "ColorMbed.h"

SPI dot_matrix(D11,NC,D13); //mosi miso sclk
DigitalOut lat(PA_12);
DigitalOut sb(PA_11);
DigitalOut rst(D10);
BusOut open_line(D2,D3,D4,D5,D6,D7,D8,D9);
              //c0 c1 c2 c3 c4 c5 c6 c7 dont foget d7
uint8_t temp;
int line[8] = {1,2,4,8,16,32,64,128};



void ColorMbed::init(){
  dot_matrix.frequency(1000000);
  uint8_t wb[3] = {255,255,255};
  rst = 1;
  wait(0.5);
  rst = 0;
  wait(0.5);
  rst = 1;
  wait(0.5);
  sb = 0; // 6 bit
  for(int i = 0; i<8; i++){
    dot_matrix.write(wb[0]);
    dot_matrix.write(wb[1]);
    dot_matrix.write(wb[2]);
  }
  open_line = 0;
  sb = 1; // 8 bit
}


void ColorMbed::display_pic(int *pic,int *color){
  for(int j = 0;j<8;j++){
    temp = pic[j];
    for(int i = 0; i<8; i++){
      if(temp & 0x80){
        dot_matrix.write(color[0]);
        dot_matrix.write(color[1]);
        dot_matrix.write(color[2]);
      }
      else{
        dot_matrix.write(0);
        dot_matrix.write(0);
        dot_matrix.write(0);
      }
      temp = temp << 1;
    }
    lat = 1;
    lat = 0;
    open_line = line[j];
    wait(0.001);
    open_line = 0;
  }
}


void ColorMbed::display_big_array(int pic[8][8][3]){
  for(int j = 0;j<8;j++){
    for(int i = 0; i<8; i++){
        dot_matrix.write(pic[j][7-i][0]);
        dot_matrix.write(pic[j][7-i][1]);
        dot_matrix.write(pic[j][7-i][2]);
    }
    lat = 1;
    lat = 0;
    open_line = line[j];
    wait(0.001);
    open_line = 0;
  }
}