/******************************************************************************/
/*                           This Nicleo is stat 0!                           */
/******************************************************************************/
#include "mbed.h"
 
// Initail I/O.
AnalogIn VRx(A2);
AnalogIn VRy(A3);
DigitalIn Button(D13);
Serial bt(PA_15, PB_7);

// Initial function.
char check_joys(int jx,int jy);
int check_joys_int(int jx,int jy);
int check_correctPosition(int X,int Y);
int get_position(int input_position,int ship_type);
void check_ready();
void print_metrix();
void Select_Position(char M);

// Initial variable.
int select_Position = 0;
int ATKposition = 0;
int iWaitATK = 0;
int U_ready = 0;
int state = 0;
int ship_notdestroy[8] = {4,3,2,2,1,1,1,1};
int ship_destroyed[8] = {0};
int ship_flor[8][8] = {{0}}; //__________________________________________________This is ship area.
int check_ship1 = 0;
int check_ship2 = 0;
int ship4[4] = {0};
int ship3[3] = {0};
int ship2[2][2] = {{0}};
int ship1[4] = {0};

int main(){ //-------------------------------------------------------------------Main Function.
    float Vx;
    float Vy;
    int SW,iVxVy,iSW,n;
    int iShipType = 0;
    char m;
    while(1) {
        if(iShipType<8){
            Vx = VRx.read() * 1024;
            Vy = VRy.read() * 1024;
            SW = Button.read();
            m = check_joys(Vx,Vy);
            n = check_joys_int(Vx,Vy);
            if(n == 1){ //_______________________________________________________ For make sure coordinate is press 1 time.
                iVxVy = 0;
                check_ready();
            }
            if(SW == 1){ //______________________________________________________ For make sure switch is press 1 time.
                iSW = 0;
                check_ready();
            }
            if(m!=NULL && iVxVy==0){ //__________________________________________ Get position that wait for press switch.
                Select_Position(m);
                check_ready();
                printf("select_Position = %d\n",select_Position);
                iVxVy = 1;
            }
            if(SW==0 && iSW==0){ //______________________________________________If switch pressing by human.
                printf("Wait!\n");
                check_ready();
                if(get_position(select_Position,ship_notdestroy[iShipType])==0){ //__Please read explanation in function get_position.
                    printf("Please input correct position\n");
                }else{
                    iShipType++;
                }
                check_ready();
                iSW = 1;
                print_metrix();
            }
        }else{
            if(U_ready!=1){bt.putc('E');}
            
            printf("\n");
            break;
        }
    }
    select_Position = 0;
    
    while(1) { //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play
        if(U_ready == 1){state = 0;}else{state = 1;}
        if(state == 1){
            printf("Your turn.\n");
            Vx = VRx.read() * 1024;
            Vy = VRy.read() * 1024;
            SW = Button.read();
            m = check_joys(Vx,Vy);
            n = check_joys_int(Vx,Vy);
            if(n == 1){ 
                iVxVy = 0;
            }
            if(SW == 1){
                iSW = 0;
            }
            if(m!=NULL && iVxVy==0){
                Select_Position(m);
                printf("select_Position = %d\n",select_Position);
                iVxVy = 1;
            }
            if(SW==0 && iSW==0){
                printf("send\n");
                bt.printf("%d",select_Position);
                state = 0;
                iSW = 1;
            }
        }else{
            while(1){
                printf("");
                if(bt.readable()){
                    // Wait for resive position of enemy that atk you.
                    iWaitATK = 1;
                }
                if(iWaitATK==1){
                    break;
                }
            }
        }
    }
}
























char check_joys(int jx,int jy){ //-----------------------------------------------Check joystick that it up,down,left or right.
    if(jx < 24.0){
        return 'a';
    }
    else if(jx > 1000.0){
        return 'd';
    }
    else if(jy < 24.0){
        return 'w';
    }
    else if(jy > 1000.0){
        return 's';
    }else{
        return NULL;
    }
}
int check_joys_int(int jx,int jy){ //--------------------------------------------Check joystick that it is centre.
    if(jx>=450.0&&jx<=600.0){
        if(jy>=450.0&&jy<=600.0){
            return 1;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}
void Select_Position(char M){ //-------------------------------------------------Change position of cursor (Joystick).
    switch(M){
        case 'a':
            if(select_Position%10!=0){select_Position = select_Position - 1;}
            break;
        case 'd':
            if(select_Position%10!=7){select_Position = select_Position + 1;}
            break;
        case 'w':
            if(select_Position/10!=0){select_Position = select_Position - 10;}
            break;
        case 's':
            if(select_Position/10!=7){select_Position = select_Position + 10;}
            break;
    }
}
int get_position(int input_position,int ship_type){ //---------------------------Plot ship in ship area.
    int i,x,y = 0;
    int error = 0;

    y = input_position/10;
    x = input_position%10;

    for(i=0;i<ship_type;i++){
        if(check_correctPosition(y,x) == 1){
            if(ship_type == 4){ship4[i] = (y*10)+x;}
            else if(ship_type == 3){ship3[i] = (y*10)+x;}
            else if(ship_type == 2){ship2[check_ship2][i] = (y*10)+x;}
            else if(ship_type == 1){ship1[check_ship1] = (y*10)+x;check_ship1++;}
        }else{
            error = 1;
            break;
        }
        if(ship_type%2 == 0){
            y++;
        }else{
            x++;
        }
    }
    if(ship_type==2){
        check_ship2++;
    }
    if(error == 1){
        return 0;
    }else{
        y = input_position/10;
        x = input_position%10;
        for(i=0;i<ship_type;i++){
            ship_flor[y][x] = ship_type;
            if(ship_type%2 == 0){
                y++;
            }else{
                x++;
            }
        }
        return 1;
    }
}
int check_correctPosition(int X,int Y){
    if(X<=7){
        if(Y<=7){
            if(ship_flor[X][Y] == 0){
                return 1;
            }else{
                return 0;
            }
        }
    }else{
        return 0;
    }
}
void print_metrix(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",ship_flor[i][j]);
        }
        printf("\n");
    }
}
void check_ready(){
    if(bt.readable()){
        U_ready = 1;
    }
}
/*
int check_when_enemyATK(int position){
    
}
*/