#include "mbed.h"
#include "BH1750.h"
#include "DHT.h"
DHT sensor(D4,SEN11301P);
DigitalOut ledout(D8);
PwmOut ledin1(D10);
PwmOut ledin2(D11);
DigitalOut motor(D12);
BH1750 lightSensor(I2C_SDA, I2C_SCL);
Serial blue(PC_6, D9);
Serial pc(D1, D0);

int i = 0,user = 0,x = 0,y = 0,err;
char light[4],humidity[4];
float f1,light_new,humidity_new;
int check = 0;
char mm = 'x';
double light_v = 0.5;

int main()
{

    lightSensor.init();
    ledin1 = light_v;
    ledin2 = light_v;
    while(true) {
        while(check == 0) {
            pc.printf("check=0");
            if(blue.readable()){
                mm = blue.getc();
            }
            if (lightSensor.readIntesity() <= 100) {
                ledout = 1;
            } else {
                ledout =0;
            }
            err = sensor.readData();
            if (err == 0) {
                if (sensor.ReadHumidity() == 2) {
                    motor = 1;
                } else {
                    motor =0;
                }
            } else {
                printf("\r\nErr %i \n",err);
            }
            if (mm == 'i') {
                check = 1;
            }
        }
        pc.printf("****************\n");
        for (i = 0 ; i <= 3 ; i++)  {
            humidity[i] = '\0';
        }
        for (i = 0 ; i <= 3 ; i++)  {
            light[i] = '\0';
        }
        if(mm == 'x') {
            mm = blue.getc();
            if (mm == 'i') {
                check = 1;
            }
        }
        pc.printf("c now = %c\n",mm);
        if (check == 1) {
            light_new = lightSensor.readIntesity()/5000;
            humidity_new = sensor.ReadHumidity()/3;
            sprintf(light,"%.2f",light_new);
            sprintf(humidity,"%.2f",humidity_new);
            if(mm == 'a') {
                pc.printf("a getting\n");
                for(i=0; i<=3; i++) {
                    blue.printf("%c",humidity[i]);
                }
                pc.printf("a send\n");
            }
            if(mm == 'b') {
                pc.printf("b send\n");
                for(i=0; i<=3; i++) {
                    blue.printf("%c",light[i]);
                }
                pc.printf("b send\n");
            }
            if(mm == '7')   {
                motor = 1;
            }
            if(mm == '4')   {
                motor = 0;
            }
            if(mm == '9')   {
                ledout = 1;
            }
            if(mm == '6')   {
                ledout = 0;
            }
            if(mm == '8')   {
                light_v = light_v + 0.05;
                ledin1 = light_v;
                ledin2 = light_v;
            }
            if(mm == '5')   {
                light_v = light_v - 0.05;
                ledin1 = light_v;
                ledin2 = light_v;
            }
            if(mm == 'o') {
                check = 0;
            }
            mm = 'x';
        }

    }
}