#include "mbed.h"
#include "MFRC522.h"
#include "TextLCD.h"
#include "string.h"
#define MF_RESET    D8
Serial blue(PC_6, D9);
DigitalOut aaa(D15);
DigitalOut myled(LED1);
AnalogIn x(A0);
AnalogIn y(A1);
AnalogIn z(A2);
DigitalOut LedGreen(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
TextLCD lcd(D2, D3, D4, D5, D6, D7, TextLCD::LCD20x4); // rs, e, d4-d7

int card_check = 0;
int i = 0;
int H = 0;
float L = 50;
int card_type = 0;
int arrow = 0;
int a,b,c = 0;
char charID[4];
char indoor[4] = {'O','F','F'};
char ON[4] = {'O','N','\0'};
char OFF[4] = {'O','F','F'};
char HC[4] = {'\0'};
char LC[4] = {'\0'};
int timming = 0;

void rfid_check()
{

    RfChip.PCD_Init();

    while (card_type == 0) {


        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(500);
            continue;
        }

        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(500);
            continue;
        }

        for (uint8_t i = RfChip.uid.size; i >= 1; i--) {
            sprintf(charID, "%X02", RfChip.uid.uidByte[i]);
        }
        pc.printf("\n-%s-\n",charID);
        if (strcmp(charID,"BF02") == 0) {
            lcd.locate(3,2);
            lcd.printf("Hello Master!!");
            card_type = 1;
            blue.printf("i");
        }

        else if (strcmp(charID,"5D02") == 0) {
            lcd.locate(2,2);
            lcd.printf("Hello Light Man!");
            card_type = 3;
            blue.printf("i");
        }

        else if (strcmp(charID,"9B02") == 0) {
            lcd.locate(2,2);
            lcd.printf("Hello Pump Man!!");
            card_type = 2;
            blue.printf("i");
            
        } else /*if (strcmp(charID,"2E02") == 0)*/ {
            card_type = 4;
        }
    }

}

void menu()
{
    blue.printf("a");
    pc.printf("a sended\n");
    for (i = 0; i <= 3 ; i++) {
        HC[i] = blue.getc();
    }
    pc.printf("a got\n");
    blue.printf("b");
    pc.printf("b sended\n");
    for (i = 0; i <= 3 ; i++) {
        LC[i] = blue.getc();
    }
    pc.printf("b got\n");
    lcd.printf("  HUMIDITY  = %.*s\n",4,HC);
    lcd.printf("  LIGHT     = %.*s\n",4,LC);
    lcd.printf("  LOG OUT\n\n");
    pc.printf("LCD SETING DONE\n");
}

void bb()
{
    while (true)  {
        if (x == 1) {
            a=1;
            while (x >= 0.7) {};
            break;
        }
        if (y == 1) {
            b=1;
            while (y >= 0.7) {};
            break;
        }
        if (z == 1) {
            c=1;
            while (z >= 0.7) {};
            break;
        }
    }
}

void menu_light()
{
    lcd.cls();
    lcd.printf("     ~~LIGHT~~\n");
    lcd.printf("  INDOOR  = %.0f %%\n",L);
    lcd.printf("  OUTDOOR = %s\n",indoor);
    lcd.printf("  BACK\n");
}

int main()
{
    while (true)     {
        for(i=0; i<4; i++) {
            charID[i]='\0';
        }
        timming = 0;
        card_type = 0;
        arrow = 1;
        lcd.cls();
        lcd.printf("\n        ^O^         \n\n");
        rfid_check();
        if (card_type == 4) {
            lcd.locate(5,2);
            lcd.printf("WHO ARE U ??");
            timming = 1;
            aaa = 1;
            wait_ms(2000);
            aaa = 0;
        }
        wait_ms(2000);
        while (timming == 0) {
            if (arrow == 1) {
                lcd.cls();
                menu();
                lcd.printf("->");
                bb();
                if (c == 1) {
                    arrow = 2;
                    c = 0;
                }
                if (b == 1) {
                    if(card_type == 2 || card_type == 1) {
                        arrow = 4;
                    }
                    b = 0;
                }
            }
            if (arrow == 2) {
                lcd.cls();
                menu();
                lcd.locate(0,1);
                lcd.printf("->");
                bb();
                if (a == 1) {
                    arrow = 1;
                    a = 0;
                }
                if (c == 1) {
                    arrow = 3;
                    c = 0;
                }
                if (b == 1) {
                    if(card_type == 3 || card_type == 1) {
                        arrow = 5;
                    }
                    b = 0;
                }
            }
            if (arrow == 3) {
                lcd.cls();
                menu();
                lcd.locate(0,2);
                lcd.printf("->");
                bb();
                if (a == 1) {
                    arrow = 2;
                    a = 0;
                }
                if (b == 1) {
                    b = 0;
                    blue.printf("o");
                    timming = 1;
                }
            }
            if (arrow == 4) {
                lcd.cls();
                lcd.printf("    ~~HUMIDITY~~\n");
                if (H == 0) {
                    lcd.printf("        %s",OFF);
                }
                if (H == 1) {
                    lcd.printf("        %s",ON);
                }
                bb();
                if (a == 1) {
                    H = 1;
                    blue.printf("7");
                    a = 0;
                }
                if (c == 1) {
                    H = 0;
                    blue.printf("4");
                    c = 0;
                }
                if (b == 1) {
                    arrow = 1;
                    b = 0;
                }
            }
            if (arrow == 5) {
                menu_light();
                lcd.locate(0,1);
                lcd.printf("->");
                bb();
                if (c == 1) {
                    arrow = 6;
                    c = 0;
                }
                if (b == 1) {
                    arrow = 51;
                    b = 0;
                }
            }
            if (arrow == 6) {
                menu_light();
                lcd.locate(0,2);
                lcd.printf("->");
                bb();
                if (a == 1) {
                    arrow = 5;
                    a = 0;
                }
                if (b == 1) {
                    arrow = 52;
                    b = 0;
                }
                if (c == 1) {
                    arrow = 7;
                    c = 0;
                }
            }
            if (arrow == 7) {
                menu_light();
                lcd.locate(0,3);
                lcd.printf("->");
                bb();
                if (a == 1) {
                    arrow = 6;
                    a = 0;
                }
                if (b == 1) {
                    arrow = 2;
                    b = 0;
                }
            }
            if (arrow == 51) {
                lcd.cls();
                lcd.printf("  ~~INDOOR LIGHT~~\n");
                lcd.printf("        %.0f %%\n\n\n",L);
                bb();
                if (a ==1 ) {
                    L = L + 5;
                    blue.printf("8");
                    a = 0;
                }
                if (c == 1 ) {
                    L = L - 5;
                    blue.printf("5");
                    c = 0;
                }
                if (b == 1 ) {
                    arrow = 5;
                    b = 0;
                }
            }
            if (arrow == 52) {
                lcd.cls();
                lcd.printf("  ~~OUTDOOR LIGHT~~\n");
                lcd.printf("       %s\n\n\n",indoor);
                bb();
                if (a ==1 ) {
                    strcpy(indoor,ON);
                    blue.printf("9");
                    a = 0;
                }
                if (c == 1 ) {
                    strcpy(indoor,OFF);
                    blue.printf("6");
                    c = 0;
                }
                if (b == 1 ) {
                    arrow = 6;
                    b = 0;
                }
            }
        }
        blue.printf("o");
    }
}