#include "mbed.h"
#include "eeprom.h"
#include "string.h"

Serial db(D1, D0);
Serial pc(PA_11, PA_12);
EEPROM memory(D14,D15,0);
PwmOut mypwm(D9);
AnalogIn rain(A2);
DigitalOut IN1(D10);
DigitalOut IN2(D11);
BusIn on(D3,D4);
I2C i2c(D5,D7);   //sda,scl
uint8_t temp_read();
uint8_t humidity();
int motor_on(uint8_t, uint8_t); // dir input(1,2) and pwm input(1-100)
void Rx_interrupt();
DigitalOut myled(LED1);
DigitalIn butt(USER_BUTTON);

char command[100];
int8_t valu;
char rx_line[100];

int main() {
   
     
    myled = 1;    

    int user = 0;
    int8_t humid1 = 0;
    int8_t speed1 = 0;
    int8_t freq1 = 0;
    int8_t humid2 = 0;
    int8_t speed2 = 0;
    int8_t freq2 = 0;
    int8_t ctemp = 0;
    int8_t chumid = 0;
    int8_t atemp1[15]={0};
    int8_t ahumi1[7]={0};
    int8_t atemp2[15]={0};
    int8_t ahumi2[7]={0};
    int mode = 0;
    
    memory.read(11,speed1);
    memory.read(12,humid1);
    memory.read(13,freq1);
    memory.read(14,speed2);
    memory.read(15,humid2);
    memory.read(16,freq2);
    Timer t;
    int clock=0;
    int c1 = 0;
    int i1 = 0;
    int c2 = 0;
    int i2 = 0;
    int t1 = -1;
    int t2 = -1;
    /*eeprom address
    u1spd = 11
    u1humit = 12
    u1ti = 13
    u2spd = 14
    u2humit = 15
    u2ti = 16
    atemp1[15] = 21-34
    ahumi1[7] =  41-46
    atemp2[15] = 51-64
    ahumi2[7] = 71-76
    */
    
    pc.baud(9600);
    
    t.start();
    while(1) {
    chumid = humidity();
    ctemp = temp_read();
        //sampling
        clock = t.read();
        if(clock%freq1==0 && clock != t1){            ///////////// USER1
            t1=clock;
            if(c1<=13){       //temp array
                atemp1[c1]=ctemp;
                c1++;
            }
            else{
                for(int i=0;i<13;i++){
                    atemp1[i] = atemp1[i+1];
                }
                atemp1[13] = ctemp;
            }
            
            if(i1<=5){        //humid array
                ahumi1[i1]=chumid;
                i1++;
            }
            else{
                for(int i=0;i<5;i++){
                    ahumi1[i] = ahumi1[i+1];
                }
                ahumi1[5] = chumid;
            }
            //save data
            for(int i=0;i<=13;i++){
                    memory.write(i+21,atemp1[i]);
                }
            for(int i=0;i<=5;i++){
                    memory.write(i+41,ahumi1[i]);
                } 
        /* debugger
        db.printf("%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d\n",atemp1[0],atemp1[1],atemp1[2],atemp1[3],atemp1[4],atemp1[5],atemp1[6],atemp1[7],atemp1[8],atemp1[9],atemp1[10],atemp1[11],atemp1[12],atemp1[13]);
        db.printf("%d:%d:%d:%d:%d:%d\n",ahumi1[0],ahumi1[1],ahumi1[2],ahumi1[3],ahumi1[4],ahumi1[5]);
        db.printf("%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d\n",atemp2[0],atemp2[1],atemp2[2],atemp2[3],atemp2[4],atemp2[5],atemp2[6],atemp2[7],atemp2[8],atemp2[9],atemp2[10],atemp2[11],atemp2[12],atemp2[13]);
        db.printf("%d:%d:%d:%d:%d:%d\n",ahumi2[0],ahumi2[1],ahumi2[2],ahumi2[3],ahumi2[4],ahumi2[5]);   
        */
        }
        
        if(clock%freq2==0 && clock != t2){              /////////////USER2
            t2 = clock;
          
            if(c2<=13){        //temp array
                atemp2[c2]=ctemp;
                c2++;
            }
            else{
                for(int i=0;i<13;i++){
                    atemp2[i] = atemp2[i+1];
                }
                atemp2[13] = ctemp;
            }
            
            if(i2<=5){         //humid array
                ahumi2[i2]=chumid;
                i2++;
            }
            else{
                for(int i=0;i<5;i++){
                    ahumi2[i] = ahumi2[i+1];
                }
                ahumi2[5] = chumid;
            }
            //save data
            for(int i=0;i<=13;i++){
                memory.write(i+51,atemp2[i]);
            }
            for(int i=0;i<=5;i++){
                memory.write(i+71,ahumi2[i]);
            } 
        }
        
        //auto mode
        if(mode==1){
            if(user==1){
                if(chumid>humid1){
                    if(on.read()!=2){
                        motor_on(2,speed1);
                    }
                }
                else if(chumid<humid1){
                        if(on.read()!=1){
                            motor_on(1,speed1);
                        }
                }      
            }
            else if(user==2){
                if(chumid>humid2){
                    if(on.read()==1){
                        motor_on(2,speed2);
                    }
                }
                else if(chumid<humid1){
                    if(on.read()!=1){
                        motor_on(1,speed2);
                    }
                }
            }
        }
        
       
        
        //get serial command
            
        if(pc.readable()){ 
            pc.scanf("%[^:]:%d",command,&valu);
            
            //db.printf("%s/%d\n",command,valu); //debugger
            //wait_ms(50);
            //pc.printf("command = %s valu = %d user = %d\n",command,valu,user);
            
           
            
            
                //call function
            if (strcmp(command,"user1")==0 || strcmp(command,"\nuser1")==0) {
               //return spd:humid_trsh:samp_frq USER1 
               user = 1;
               memory.read(11,speed1);
               memory.read(12,humid1);
               memory.read(13,freq1);
               
               pc.printf("%d:%d:%d\n",speed1,humid1,freq1);
                  
            }
            else if(strcmp(command,"user2")==0 || strcmp(command,"\nuser2")==0){
                //return spd:humid_trsh:samp_frq USER2
               user = 2; 
               memory.read(14,speed2);
               memory.read(15,humid2);
               memory.read(16,freq2);
               
               pc.printf("%d:%d:%d\n",speed2,humid2,freq2);
               
            }
            else if(strcmp(command,"auto")==0 || strcmp(command,"\nauto")==0){
                //auto mode
                //return 'ok'
                mode = 1;
                pc.printf("ok\n");
            }
            else if(strcmp(command,"on")==0 || strcmp(command,"\non")==0){
                //motor on 
                mode = 0; 
                if(user==1){
                    motor_on(1,speed1);
                }
                else{
                    motor_on(1,speed2);
                }
                //return 'ok'
                pc.printf("ok\n");
                  
            }
            else if(strcmp(command,"off")==0 || strcmp(command,"\noff")==0){
                //off motor
                mode = 0; 
                if(user==1){
                    motor_on(2,speed1);
                }
                else{
                    motor_on(2,speed2);
                }   
                //return 'ok' 
                pc.printf("ok\n");
            }
            else if(strcmp(command,"speed")==0 || strcmp(command,"\nspeed")==0){
                //motor spd = int8_t valu 
                if(user == 1){
                    memory.write(11,valu);
                }
                else if(user == 2){
                    memory.write(14,valu);
                }
                //return 'ok'
                pc.printf("ok\n");
            }
            else if(strcmp(command,"humidity")==0 || strcmp(command,"\nhumidity")==0){
                //humid_trsh = int8_t valu 
                if(user == 1){
                    memory.write(12,valu);
                }
                else if(user == 2){
                    memory.write(15,valu);
                }
                //return 'ok'
                pc.printf("ok\n");
            }
            else if(strcmp(command,"time")==0 || strcmp(command,"\ntime")==0){
                //samp_frq = int8_t valu
                if(user == 1){
                    memory.write(13,valu);
                }
                else if(user == 2){
                    memory.write(16,valu);
                }
                //return 'ok'
                pc.printf("ok\n");
            }
            else if(strcmp(command,"get")==0 || strcmp(command,"gget")==0 || strcmp(command,"\nget")==0 || strcmp(command,"\ngget")==0){
                //return temp:humid  
                pc.printf("%d:%d\n",ctemp,chumid);
                //db.printf("---%d:%d\n",ctemp,chumid);  
            }
            else if(strcmp(command,"gettemp")==0 || strcmp(command,"\ngettemp")==0){
                //return temp t:t:t:t x14   
                if(user==1){
                    pc.printf("%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d\n",atemp1[0],atemp1[1],atemp1[2],atemp1[3],atemp1[4],atemp1[5],atemp1[6],atemp1[7],atemp1[8],atemp1[9],atemp1[10],atemp1[11],atemp1[12],atemp1[13]);
                }
                else if(user==2){
                    pc.printf("%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d:%d\n",atemp2[0],atemp2[1],atemp2[2],atemp2[3],atemp2[4],atemp2[5],atemp2[6],atemp2[7],atemp2[8],atemp2[9],atemp2[10],atemp2[11],atemp2[12],atemp2[13]);
                }
            }
            else if(strcmp(command,"gethumi")==0 || strcmp(command,"\ngethumi")==0){
                //return humid h:h:h:h x6    
                if(user==1){
                    pc.printf("%d:%d:%d:%d:%d:%d\n",ahumi1[0],ahumi1[1],ahumi1[2],ahumi1[3],ahumi1[4],ahumi1[5]);
                }
                else if(user==2){
                    pc.printf("%d:%d:%d:%d:%d:%d\n",ahumi2[0],ahumi2[1],ahumi2[2],ahumi2[3],ahumi2[4],ahumi2[5]);    
                } 
            }
            
        
     }   
        
        
           
       
    }//mainwhile
}//main


int motor_on(uint8_t dir, uint8_t pwm)
{
    float a;
    a=pwm;
    a=a/100;
    mypwm.write(a);
    if(dir==1) {
        do {
            IN1=1;
            IN2=0;
        } while(on.read()!=1);
            IN1=0;
            IN2=0;
    }//end on
    if(dir==2) {
        do {
            IN1=0;
            IN2=1;
        } while(on.read()!=2);
            IN1=0;
            IN2=0;
    }//end off
    return 0;
}// end function

uint8_t humidity()
{
    return 100-(rain.read()*100);
}// end function

uint8_t temp_read()
{
    uint8_t ch;
    char p1,p2;
    float temp;
    i2c.start();
    ch=i2c.write(0xB4);

    if(!ch)return false;
    ch=i2c.write(0x07);

    if(!ch)return false;
    i2c.start();
    ch=i2c.write(0xB5);

    if(!ch)return false;

    p1=i2c.read(1);     //Tobj low byte
    p2=i2c.read(1);     //Tobj heigh byte
    i2c.read(0);

    i2c.stop();
    

    temp=((((p2&0x007f)<<8)+p1)*0.02)-0.01;
    //printf("%.0f\n", temp-273);
    return (int)temp-273;
}
