#include "mbed.h"

BusOut switchOut(D2, D3, D4, D5);
BusIn switchIn(D8, D9, D10, D11);
DigitalIn mode1(D13);
DigitalIn mode2(D12);
AnalogIn a0(A0);
AnalogIn a1(A1);
AnalogIn a2(A2);
Serial pc(USBTX, USBRX);
Serial slave(PA_11,PA_12);
void controlChange(uint8_t channel, uint8_t control, uint8_t value);
void noteOn(uint8_t channel, uint8_t pitch, uint8_t velocity);
void noteOff(uint8_t channel, uint8_t pitch);
char mode = '1';
uint8_t keymap1[4][4]= {{0x2D,0x2E,0x2F,0x30},{0x31,0x32,0x33,0x34},{0x35,0x36,0x37,0x38},{0x39,0x3A,0x3B,0x3C}};
uint8_t keymap2[4][4]= {{0x2D,0x2E,0x2F,0x30},{0x31,0x32,0x33,0x34},{0x35,0x36,0x37,0x38},{0x39,0x3A,0x3B,0x3C}};
uint8_t channalmap[4][4]= {{1,1,1,1},{1,1,1,1},{2,2,2,2},{2,2,2,2}};
Timer t;
uint32_t beat_ms = 150;
uint32_t previous=0,current;
/*uint8_t sequence[2][22]= {{0x32,0x2F,0x2F,0x32,0x2F,0x2F,0x32,0x2F,0x2F,0x39,0x00,0x38,0x37,0x35,0x35,0x33,0x31,0x31,0x30,0x2E,0x2E,0x00},
    {127,127,127,127,127,127,127,127,127,127,0,127,127,127,127,127,127,127,127,127,127,0}
};*/
uint8_t sequence[3][38]= {{
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x32,0x2F,0x2F,0x00,0x32 ,0x2F,0x2F,0x00,0x32,0x2F, 0x2F,
        0x00,0x39,0x00,0x00 ,0x38,0x37,0x35,0x00,0x35, 0x33,0x31,0x00,0x31,0x30, 0x2E,0x00,0x2E,0x00,0x00
    },
    {0,0,0,0,0,0,0,0, 127,127,127,0,127, 127,127,0,127,127 ,127,0,127,0,0 ,127,127,127,0,127 ,127,127,0,127,127 ,127,0,127,0,0},
    {1,1,2,0,4, 4,3,0,3,3, 1,2,0,4,2, 2,0,1,0,0, 3,3,4,0,1, 1,2,0,3,3,    0,0,0,0,0,0,0,0}
};

int i = 1;
//uint8_t song[];

int main()
{
    //uint8_t sw;
    int bacsw[4][4] = {0};
    int addsw[4][4] = {0};
    int sw[4];
    pc.baud(115200);
    slave.baud(115200);
    t.start();
    //current = t.read_ms();


    while(1) {

        if(mode == '2') {
            i = 1;
            while(mode == '2') {
                if(mode1 == 0){
                    mode = '1';
                    noteOff(1,sequence[0][i-1+6]+20);
                    slave.printf("#1");
                    }
                current = t.read_ms();
                if(current-previous >= beat_ms) {
                    if(i>38) {

                        i = 1;
                        noteOff(1,sequence[i+4][0]);
                    }
                    for(int j = 0;j<4;j++){
                        if(addsw[j][sequence[2][sequence[2][i]]-1]==1){
                            noteOn(1,sequence[0][i+6]+20,sequence[1][i+4]);
                            break;
                            }
                        }
                    
                    noteOff(1,sequence[0][i-1+4]+20);
                    //wait_us(20);
                    slave.printf("*%c",sequence[2][i-1]+'0');
                    i++;
                    previous = t.read_ms();
                }
                for(int i = 0 ; i<4 ; i++) {
                    switch( i) {
                        case 0:
                            switchOut = 0b1110;
                            sw[i] = 15-switchIn;
                            break;
                        case 1:
                            switchOut = 0b1101;
                            sw[i] = 15-switchIn;
                            break;
                        case 2:
                            switchOut = 0b1011;
                            sw[i] = 15-switchIn;
                            break;
                        case 3:
                            switchOut = 0b0111;
                            sw[i] = 15-switchIn;
                            break;
                    }
                }
                for(int i=0; i<4 ; i++) {
                    if(sw[i]>7) {
                        addsw[i][0] = 1;
                        sw[i]= sw[i]-8;
                    } else
                        addsw[i][0] = 0;
                    if(sw[i]>3) {
                        addsw[i][1] = 1;
                        sw[i] = sw[i] - 4;
                    } else
                        addsw[i][1] = 0;
                    if(sw[i]>1) {
                        addsw[i][2] = 1;
                        sw[i] = sw[i] - 2;
                    } else
                        addsw[i][2] = 0;
                    if(sw[i]>0) {
                        addsw[i][3] = 1;
                        sw[i] = sw[i] - 1;
                    } else
                        addsw[i][3] = 0;
                }


                for(int i =0; i<4; i++) {
                    for(int j =0 ; j <4; j++) {
                        if(addsw[i][j] != bacsw[i][j]) {
                            //pc.printf("(%d,%d)",i,j);

                            if(addsw[i][j] ==1) {
                                //noteOn(channalmap[i][j],keymap1[i][j],127);
                                slave.printf("$1%c%c",'0'+i,'0'+j);
                            } else {
                                //noteOff(channalmap[i][j],keymap1[i][j]);
                                slave.printf("$0%c%c",'0'+i,'0'+j);
                            }
                        }
                    }
                }
                memcpy(bacsw,addsw,sizeof(bacsw));
            }
        }
        if(mode == '1') {
            int volume;
            int shift;
            while(mode == '1') {
                 volume = 127-a0.read()*127;
                 shift = a1.read()*4;
                 if(mode2 == 0){
                    mode = '2';
                    slave.printf("#2");
                    }
                for(int i = 0 ; i<4 ; i++) {
                    switch( i) {
                        case 0:
                            switchOut = 0b1110;
                            sw[i] = 15-switchIn;
                            break;
                        case 1:
                            switchOut = 0b1101;
                            sw[i] = 15-switchIn;
                            break;
                        case 2:
                            switchOut = 0b1011;
                            sw[i] = 15-switchIn;
                            break;
                        case 3:
                            switchOut = 0b0111;
                            sw[i] = 15-switchIn;
                            break;
                    }
                }
                for(int i=0; i<4 ; i++) {
                    if(sw[i]>7) {
                        addsw[i][0] = 1;
                        sw[i]= sw[i]-8;
                    } else
                        addsw[i][0] = 0;
                    if(sw[i]>3) {
                        addsw[i][1] = 1;
                        sw[i] = sw[i] - 4;
                    } else
                        addsw[i][1] = 0;
                    if(sw[i]>1) {
                        addsw[i][2] = 1;
                        sw[i] = sw[i] - 2;
                    } else
                        addsw[i][2] = 0;
                    if(sw[i]>0) {
                        addsw[i][3] = 1;
                        sw[i] = sw[i] - 1;
                    } else
                        addsw[i][3] = 0;
                }


                for(int i =0; i<4; i++) {
                    for(int j =0 ; j <4; j++) {
                        if(addsw[i][j] != bacsw[i][j]) {
                            //pc.printf("(%d,%d)",i,j);

                            if(addsw[i][j] ==1) {
                                noteOn(channalmap[i][j],keymap1[i][j]-9+8*shift,volume);
                                slave.printf("$1%c%c",'0'+i,'0'+j);
                            } else {
                                noteOff(channalmap[i][j],keymap1[i][j]-9+8*shift);
                                slave.printf("$0%c%c",'0'+i,'0'+j);
                            }
                        }
                    }
                }
                memcpy(bacsw,addsw,sizeof(bacsw));
            }
        }
    }
}
void noteOn(uint8_t channel, uint8_t pitch, uint8_t velocity)
{
    channel += 0x90 - 1;
    if (channel >= 0x90 && channel <= 0x9F) {
        pc.putc(channel);
        pc.putc(pitch);
        pc.putc(velocity);
    }
}

// Send a MIDI note off message
void noteOff(uint8_t channel, uint8_t pitch)
{
    channel += 0x80 - 1;
    if (channel >= 0x80 && channel <= 0x8F) {
        pc.putc(channel);
        pc.putc(pitch);
        pc.putc((uint8_t)0x00);
    }
}

// Send a MIDI control change message
void controlChange(uint8_t channel, uint8_t control, uint8_t value)
{
    channel += 0xB0 - 1;
    if (channel >= 0xB0 && channel <= 0xBF) {
        pc.putc(channel);
        pc.putc(control);
        pc.putc(value);
    }
}