#include "mbed.h"
#include "iteadstudio_colourshield.h"
uint8_t frame[8][8][3]= {0};
char mode = '1';
char read = '0';
char readon,readi,readj;
char trig = '0';
char trigkey;
uint8_t keyarray[4][4] = {{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
DigitalIn usrin(PC_13);
inline void midicon_display(uint8_t array[4][4],uint8_t BGR_col_map[4][4][3]);
inline void midi_rythm_display(uint8_t BGR_col_map88[8][8][3]);
Serial master(PA_11,PA_12);
Serial pc(USBTX, USBRX);
Timer timer;
Timer timer2;
int scount;


int begin;
void callback()
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    if(pc.getc()=='#') {
        mode = pc.getc();
        pc.putc(mode);
    }
}
void callbackmaster()
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    read =master.getc();
    if(read=='#') {
        mode = master.getc();
        pc.putc(mode);
    } else if(read == '$') {
        //pc.putc(read);
        readon = master.getc();
        //pc.putc(readon);
        readi=master.getc();
        //pc.putc(readi);
        readj=master.getc();
        //pc.putc(readj);
        //pc.putc('\n');
        if(readon=='1') {
            keyarray[3-(readj-'0')][(readi-'0')] =1;
        }
        if(readon=='0') {
            //pc.putc('X');
            keyarray[3-(readj-'0')][readi-'0'] = 0;
        }
    } else if(read == '*') {
        trig ='1';
        pc.putc('!');
        trigkey = master.getc();
        pc.putc(trigkey);
        pc.putc('\n');
    } else {
        pc.putc('-');
        pc.putc(read);
        pc.putc('-');
        pc.putc('\n');
    }
}
int main()
{
    timer.start();
    pc.baud(115200);
    pc.attach(&callback);
    master.baud(115200);
    master.attach(&callbackmaster);

    char wb[3]= {100,100,100};
    INITRGB(wb);
    float r,g,b;
    //float HSV[3];

    while(1) {
        if(mode=='0') {
            for(int i =0; i<8; i++) {
                for(int j= 0; j<8; j++) {
                    HSVtoRGB(&r,&g,&b,i*j*360/49,1,1);
                    frame[i][j][0]=(uint8_t)(b*230);
                    frame[i][j][1]=(uint8_t)(g*255);
                    frame[i][j][2]=(uint8_t)(r*155);

                }
            }
            while(mode == '0') {
                sendframe(frame);
                displayRGB();


            }
        }
        if(mode=='1') {
            //rainbow keymap

            uint8_t bgr_col_map[4][4][3];

            int key = 0;
            for(int i=0 ; i<4; i++) {
                for(int j=0 ; j<4; j++) {
                    HSVtoRGB(&r,&g,&b,key*360/15,1,1);
                    bgr_col_map[j][i][0] = (uint8_t)(b*230);
                    bgr_col_map[j][i][1] = (uint8_t)(g*255);
                    bgr_col_map[j][i][2] = (uint8_t)(r*155);
                    key++;
                }
            }

            while(mode == '1') {
                midicon_display(keyarray,bgr_col_map);
            }

        } else if(mode=='2') {
            uint8_t rythm_col_map[8][8][3];
            //first col
            for(int i = 0; i<2; i++) {
                for(int j =0; j<6; j++) {
                    HSVtoRGB(&r,&g,&b,0,0,1);
                    rythm_col_map[i][j][0]=(uint8_t)(b*230);
                    rythm_col_map[i][j][1]=(uint8_t)(g*255);
                    rythm_col_map[i][j][2]=(uint8_t)(r*155);
                }
            }
            //second col
            for(int i = 2; i<4; i++) {
                for(int j =0; j<6; j++) {
                    HSVtoRGB(&r,&g,&b,0,0,1);
                    rythm_col_map[i][j][0]=(uint8_t)(b*230);
                    rythm_col_map[i][j][1]=(uint8_t)(g*255);
                    rythm_col_map[i][j][2]=(uint8_t)(r*155);
                }
            }
            //third col
            for(int i = 4; i<6; i++) {
                for(int j =0; j<6; j++) {
                    HSVtoRGB(&r,&g,&b,0,0,1);
                    rythm_col_map[i][j][0]=(uint8_t)(b*230);
                    rythm_col_map[i][j][1]=(uint8_t)(g*255);
                    rythm_col_map[i][j][2]=(uint8_t)(r*155);
                }
            }
            //last col
            for(int i = 6; i<8; i++) {
                for(int j =0; j<6; j++) {
                    HSVtoRGB(&r,&g,&b,0,0,1);
                    rythm_col_map[i][j][0]=(uint8_t)(b*230);
                    rythm_col_map[i][j][1]=(uint8_t)(g*255);
                    rythm_col_map[i][j][2]=(uint8_t)(r*155);
                }
            }
            //allbutton
            for(int i = 0; i<8; i++) {
                for(int j =6; j<8; j++) {
                    HSVtoRGB(&r,&g,&b,0,0,1);
                    rythm_col_map[i][j][0]=(uint8_t)(b*230);
                    rythm_col_map[i][j][1]=(uint8_t)(g*255);
                    rythm_col_map[i][j][2]=(uint8_t)(r*155);
                }
            }

            uint8_t canvas[8][8][3];
            //int velocity_ms = 100;
            uint8_t padobject[4][6][2] = {0}; //col,maxnumber of obj,avalibility,pos
            int i2;
            memcpy(canvas,rythm_col_map,sizeof(canvas));
            while(mode == '2') {




                if(trig=='1') {
                    memcpy(canvas,rythm_col_map,sizeof(canvas));
                    trig='0';
                    for(int i = 0 ; i<6; i++) {
                        if(trigkey-'0'!=0)
                            if(padobject[trigkey-'0'-1][i][0]==0) {
                                padobject[trigkey-'0'-1][i][0]=1;
                                break;
                            }
                    }
                    for(int i =0; i<4; i++) {
                        for(int j= 0; j<6; j++) {
                            if(padobject[i][j][0]==1) {
                                if(padobject[i][j][1]>5) {
                                    padobject[i][j][0] = 0;
                                    padobject[i][j][1] = 0;
                                } else {
                                    //pc.putc('#');
                                    i2 = i*2;
                                    canvas[i2][padobject[i][j][1]][0]=(uint8_t)(230);
                                    canvas[i2][padobject[i][j][1]][1]=(uint8_t)(204);
                                    canvas[i2][padobject[i][j][1]][2]=(uint8_t)(0);
                                    canvas[i2+1][padobject[i][j][1]][0]=(uint8_t)(230);
                                    canvas[i2+1][padobject[i][j][1]][1]=(uint8_t)(204);
                                    canvas[i2+1][padobject[i][j][1]][2]=(uint8_t)(0);
                                    padobject[i][j][1]++;
                                }
                            }
                        }
                    }
                }
                sendframe(canvas);
                displayRGB();
            }
        }
    }
}
inline void midicon_display(uint8_t array[4][4],uint8_t BGR_col_map44[4][4][3])
{
    uint8_t frameX[8][8][3]= {0};
    //memset(frameX,30,sizeof(frameX));
    //memcpy(frameX,BGR_bac_map88,sizeof(frameX));
    int n_x,n_y;
    for( int x=0; x<4; x++) {
        for( int y=0; y<4; y++) {
            if(array[x][y]==1) {


                n_x = x*2;
                n_y = y*2;
                frameX[n_x][n_y][0] = BGR_col_map44[x][y][0];
                frameX[n_x][n_y][1] = BGR_col_map44[x][y][1];
                frameX[n_x][n_y][2] = BGR_col_map44[x][y][2];

                frameX[n_x+1][n_y][0] = BGR_col_map44[x][y][0];
                frameX[n_x+1][n_y][1] = BGR_col_map44[x][y][1];
                frameX[n_x+1][n_y][2] = BGR_col_map44[x][y][2];

                frameX[n_x][n_y+1][0] = BGR_col_map44[x][y][0];
                frameX[n_x][n_y+1][1] = BGR_col_map44[x][y][1];
                frameX[n_x][n_y+1][2] = BGR_col_map44[x][y][2];

                frameX[n_x+1][n_y+1][0] = BGR_col_map44[x][y][0];
                frameX[n_x+1][n_y+1][1] = BGR_col_map44[x][y][1];
                frameX[n_x+1][n_y+1][2] = BGR_col_map44[x][y][2];



            }
        }
    }
    sendframe(frameX);
    displayRGB();
}


