#include "mbed.h"
#include "iteadstudio_colourshield.h"
/**************Define*************************/
DigitalOut RGB_RST(A2);
DigitalOut RGB_LAT(A1);
DigitalOut RGB_SB(A0);

/*DigitalIn nn0(D7);
DigitalIn nn1(D2);
DigitalIn nn2(D6);*/
SPI RGB_SPI(PB_15,PB_14,PB_13);
BusOut RGB_CP(D8,D9,D10,D11,D12,D13,D3,D4);
uint8_t RGBi= 0,RGBj= 0,RGBk= 0;
uint8_t RedWB=55,GreenWB=0,BlueWB=60; // percent | R,G,B calibrate change it if some color brighter than other
uint8_t display[8][8][3]= {0};
/*******************************************/
void sendframe(uint8_t frame[8][8][3])
{
    memcpy(display, frame, sizeof(display));
}
void INITRGB(char in[3])
{
    int wd;
    RGB_RST =0;
    RGB_RST =1;
    RGB_SPI.frequency(20000000);
    RGB_SPI.format(8,1);
    RGB_LAT = 0;
    RGB_SB  =0;
    int l=0;

    for (int i = 0; i<8; i++) { // Whitebalance......**important
        for (int j = 0; j<3; j++) {
            for (int k = 0; k<6; k++) {
                wd+=((in[j]<<k)&0b00100000)?1:0;
                wd<<1;
                l++;
                if(l>=7) {
                    RGB_SPI.write(255);
                    l=0;
                }
            }
            //RGB_SPI.write(255);
        }
    }

    RGB_LAT = 1;
    RGB_LAT = 0;

    RGB_SPI.format(8,0);
}

void displayRGB()
{

    RGB_SB  =1;
    for( RGBi=0; RGBi<8; RGBi++) {
        for( RGBk=0; RGBk<8; RGBk++) {
            for( RGBj=0; RGBj<3; RGBj++) {
                RGB_SPI.write(display[RGBk][RGBi][RGBj]);
            }

        }
        RGB_CP = 0;
        wait_us(15);
        RGB_LAT = 1;
        RGB_LAT = 0;

        RGB_CP = (0x01<<RGBi);

    }
}

void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
    int i;
    float f, p, q, t;
    if( s == 0 ) {
        // achromatic (grey)
        *r = *g = *b = v;
        return;
    }
    h /= 60;            // sector 0 to 5
    i = floor( h );
    f = h - i;          // factorial part of h
    p = v * ( 1 - s );
    q = v * ( 1 - s * f );
    t = v * ( 1 - s * ( 1 - f ) );
    switch( i ) {
        case 0:
            *r = v;
            *g = t;
            *b = p;
            break;
        case 1:
            *r = q;
            *g = v;
            *b = p;
            break;
        case 2:
            *r = p;
            *g = v;
            *b = t;
            break;
        case 3:
            *r = p;
            *g = q;
            *b = v;
            break;
        case 4:
            *r = t;
            *g = p;
            *b = v;
            break;
        default:        // case 5:
            *r = v;
            *g = p;
            *b = q;
            break;
    }
}
void screen_zeros()
{
    memset(display, 0, sizeof(display));
}




































