#include "mbed.h"
#include "SDFileSystem.h"
#include "LCDTaonoi.h"
#include "QEI.h"
#include <string>
#include <vector>

Serial pc(SERIAL_TX, SERIAL_RX);
Serial device(D8,D2);
Serial phone(PA_11,PA_12);
SDFileSystem sd(D11, D12, D13, D10,"sd");
LCDTaonoi lcd(I2C_SDA, I2C_SCL);
QEI encoder(A0, A1);


DigitalIn btn(A2);


void initial();
int selectMenu(string head,vector<string> strVec);
void getTemperature();
void displayData();
string stringData(char ch,string cmd);
void ProcessCmd(string cmd);
void ProcessFile(string filename);

vector<string> strDisplay;
vector<string> strMode;
vector<string> strFilename;
vector<string> strBackground;
vector<string> strSize;

int selectItem[5];
bool can_back = false;
Timer timer;
Ticker TimetickTemp;
Ticker TimetickLCD;
DigitalInOut TempSensor(D4);
DigitalOut TempStatus(D3);
int temperature=0;
float process=99.9;
int run=0;
int FullSize=0,NowSize=0;
int fexit=0;

int main()
{
    pc.baud(9600);
    device.baud(9600);
    phone.baud(9600);

    pc.printf("\nHello World\n");
    
    TimetickTemp.attach(&getTemperature, 0.5);
    TimetickLCD.attach(&displayData, 1.0);

    initial();

//////////////////////////////// Main LCD Process //////////////////////
mainmenu:
    can_back = false;
    selectItem[0] = selectMenu("*** SELECT  MODE ***",strMode);

    if(selectItem[0]==0) {
filemenu:
        selectItem[1] = selectMenu("** FILES TO PRINT **",strFilename);

        if(selectItem[1]==strDisplay.size()-1) {
            goto mainmenu;
        } else {
bgmenu:
            selectItem[2] = selectMenu("**** BACKGROUND ****",strBackground);
            if(selectItem[2]==strDisplay.size()-1) {
                goto filemenu;
            } else {
                selectItem[3] = selectMenu("***** BG SIZES *****",strSize);
                if(selectItem[3]==strDisplay.size()-1) {
                    goto bgmenu;
                } else {
                    lcd.clear();
                    lcd.print("PROCESS     :");
                    lcd.setCursor(0,1);
                    lcd.print("TEMPERATURE :");
                    lcd.setCursor(0,3);
                    lcd.print("FILE: ");
                    lcd.print(strFilename[selectItem[1]].c_str());
                }
            }
        }
    } else if(selectItem[0]==1) {
        lcd.clear();
        lcd.print(" AUTO PANCAKE MAKER ");
        lcd.setCursor(0,2);
        lcd.print("TEMPERATURE :");
        while(btn.read()) {
            lcd.setCursor(15,2);
            //getTemperature();
            string temp;
            sprintf(&temp[0],"%.1fC",float(temperature)/10);
            lcd.print(temp.c_str());
            //wait(0.2);
        }
        while(!btn.read());
        goto mainmenu;
    } else if(selectItem[0]==2) {
        lcd.clear();
        lcd.print(" AUTO PANCAKE MAKER ");
        lcd.setCursor(0,2);
        lcd.print("   GET GCODE FROM   ");
        lcd.setCursor(0,3);
        lcd.print("     SMARTPHONE     ");
        while(btn.read()) {
            if(phone.readable()) {
                char ch = phone.getc();
                pc.putc(ch);
                 device.putc(ch);
            }
        } 
        while(!btn.read());
        goto mainmenu;
    }
////////////////////////////////////////////////////////////////////

    run=1;
    pc.printf("Send File GCODE\n");
    ProcessFile(strFilename[selectItem[1]].c_str());

    run=0;
    if(!fexit) {
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("  WAITING TO FILL   ");
        lcd.setCursor(0,1);
        lcd.print("====================");
        lcd.setCursor(0,3);
        lcd.print(" AUTO PANCAKE MAKER ");

        device.printf("$%d S%d\r",selectItem[2]+1,selectItem[3]+1);
        while(1) {
            if(device.readable()) {
                if(device.getc()=='$') {
                    break;
                }
            }
        }
        lcd.clear();
    } else {
        goto mainmenu;
    }
    fexit=0;












    lcd.clear();
    while(btn.read());
    while(!btn.read());
    pc.printf("\nGoodBye World\n");
}





void initial()
{
    pc.printf("DEBUG initial");

    lcd.clear();
    lcd.print("***** WELCOME! *****");
    lcd.setCursor(0,1);
    lcd.print(" AUTO PANCAKE MAKER ");
    lcd.setCursor(0,3);
    lcd.print("   PRESS TO START   ");

    strMode.push_back("PRINT FILE");
    strMode.push_back("WATCH TEMPERATURE");
    strMode.push_back("SMART PHONE");
    string path = "/sd/FileToPrint";
    struct dirent *dirp;
    DIR *dp = opendir(path.c_str());
    while((dirp = readdir(dp)) != NULL) {
        strFilename.push_back(string(dirp->d_name));
    }
    closedir(dp);

    strBackground.push_back("SQUARE");
    strBackground.push_back("CIRCLE");
    strBackground.push_back("ELLIPS");

    strSize.push_back("FIT");
    strSize.push_back("NORMAL");
    strSize.push_back("LARGE");

    pc.printf(" - end initial\n");

    while(btn.read());
    while(!btn.read());
}




void ProcessFile(string filename)
{
    NowSize=0;
    process=0.0;
    bool comment = false;
    string cmd="";
    string readPath = "/sd/FileToPrint/" + filename;

    FILE *fInput = fopen(readPath.c_str(), "r");

    if (fInput != NULL) {
        fseek( fInput, 0, SEEK_END );
        FullSize = ftell(fInput);
        rewind(fInput);

        int8_t ch = fgetc(fInput);
        while(ch != EOF) {
            if(ch != '\n') {
                if (ch == '(') comment = true;
                if (!comment) cmd.push_back(ch);
                if (ch == ')') comment = false;
            } else {
                wait_us(100);
                if(cmd.size()>1) {
                    if(!cmd.find("G0 ")||!cmd.find("G1 ")||!cmd.find("G2 ")||!cmd.find("G3 ")) {
                        ProcessCmd(cmd);
                    }
                }
                cmd.clear();
            }
            if(!btn.read()) {
                ch = EOF;
                fexit=1;
                break;
            } else {
                ch = fgetc(fInput);
            }
            NowSize++;
            process = float(NowSize)/float(FullSize)*100;

        }
        process = 100.0;
    }
    fclose(fInput);

}

void ProcessCmd(string cmd)
{
    string tempCmd="",sendCmd="";

    if(!cmd.find("G0 ") || !cmd.find("G1 "))sendCmd = "G0 ";
    else if(!cmd.find("G2 "))sendCmd = "G2 ";
    else if(!cmd.find("G3 "))sendCmd = "G3 ";

    if(cmd.find('X',0)!= std::string::npos)sendCmd.append(stringData('X',cmd));
    if(cmd.find('Y',0)!= std::string::npos)sendCmd.append(stringData('Y',cmd));
    if(cmd.find('Z',0)!= std::string::npos)sendCmd.append(stringData('Z',cmd));
    if(cmd.find('I',0)!= std::string::npos)sendCmd.append(stringData('I',cmd));
    if(cmd.find('J',0)!= std::string::npos)sendCmd.append(stringData('J',cmd));

    device.printf("%s\r",sendCmd.c_str());
    pc.printf("Device : %s\n\r",sendCmd.c_str());
    while(1) {
        if(device.readable()) {
            if(device.getc()=='#') {
                break;
            }
        }
        if(pc.readable()) {
            if(pc.getc()=='#') {
                break;
            }
        }
    }
}

string stringData(char ch,string cmd)
{
    size_t pos = cmd.find(ch,0);
    string tempCmd,temp = cmd.substr(pos+1,8);
    float number = atof(temp.c_str());
    if(ch=='Z')number = number>0?1.0:0.0;
    sprintf(&tempCmd[0],"%c%.3f ",ch,number);
    return tempCmd.c_str();
}

int selectMenu(string head,vector<string> strVec)
{
    pc.printf("DEBUG selectMemu\n");

    lcd.clear();
    lcd.print(head.c_str());

    strDisplay.clear();
    for(int i=0; i<strVec.size(); i++)
        strDisplay.push_back(strVec[i].c_str());
    if(can_back)strDisplay.push_back("<< BACK");
    /*for(int i=0; i<strDisplay.size(); i++)
        pc.printf("%s\n",strDisplay[i].c_str());*/


    int item_index = 0;
    int list_index = 0;
    int last_index = 1;
    lcd.setCursor(0,item_index+1);
    lcd.print("->");

    while(btn.read()) {
        item_index+=encoder.getDirection();

        if(item_index>2) {
            item_index=2;
            list_index++;
            for(int i=1; i<4; i++) {
                lcd.setCursor(3,i);
                lcd.print("               ");
            }
        }
        if(item_index<0) {
            item_index=0;
            list_index--;
            for(int i=1; i<4; i++) {
                lcd.setCursor(3,i);
                lcd.print("               ");
            }
        }
        if(item_index>strDisplay.size()-1)item_index = strDisplay.size()-1;
        if(list_index<=0)list_index=0;
        if(list_index>strDisplay.size()-3)list_index=strDisplay.size()-3;

        if(item_index != last_index) {
            lcd.setCursor(0,last_index+1);
            lcd.print("  ");
            lcd.setCursor(0,item_index+1);
            lcd.print("->");
            last_index = item_index;
        }

        if(strDisplay.size()<=3) {
            for(int i=0; i<strDisplay.size(); i++) {
                lcd.setCursor(3,i+1);
                lcd.print(strDisplay[i].c_str());
            }
        }   else {
            lcd.setCursor(3,1);
            lcd.print(strDisplay[list_index].c_str());
            lcd.setCursor(3,2);
            lcd.print(strDisplay[list_index+1].c_str());
            lcd.setCursor(3,3);
            lcd.print(strDisplay[list_index+2].c_str());
        }
        wait(0.05);
    }
    while(!btn.read());
    can_back=true;
    pc.printf("%d %s\n",item_index+list_index,strDisplay[item_index+list_index].c_str());
    return item_index+list_index;
}

void getTemperature()
{
    int start,end;
    timer.start();

    TempSensor.output();
    TempSensor.write(0);
    wait_ms(10);
    TempSensor.write(1);
    wait_us(40);
    TempSensor.input();

    while (!TempSensor.read());
    start = timer.read_us();
    while (TempSensor.read());
    end = timer.read_us();

    if (end - start> 60) {
        for (int i = 0; i < 32; i++) {
            while (!TempSensor.read());
            start = timer.read_us();
            while (TempSensor.read());
            end = timer.read_us();

            if (end - start > 50) {
                temperature <<= 1;
                temperature |= 1;
            } else {
                temperature <<= 1;
            }
        }
        temperature &= 0xFFFF;
    }
    timer.reset();
    //pc.printf("Temperature : %d\n",temperature);
}
void displayData()
{

    if(run==1) {
        lcd.setCursor(15,1);
        string temp;
        sprintf(&temp[0],"%.1fC",float(temperature)/10);
        lcd.print(temp.c_str());
        temp.clear();
        lcd.setCursor(15,0);
        sprintf(&temp[0],"%.2f",process);
        lcd.print(temp.c_str());

    }
}
