#include "mbed.h"
#include "LCD4884.h"
#include <string.h>
#include <time.h>
#include <stdlib.h>
#define maxLvl 3
#define high 24
#define width 24

Ticker t;
Timer me;

DigitalOut myled(LED1);
DigitalOut buzz(PC_3);
AnalogIn LDR(A5);
Serial pc(PA_15, PB_7); 

/*
    modeA = watch time
    modeB = before alarm
    modeC = set alarm
    modeD = play games
    modeE = watch Data
    modeF = bluetooth
*/

LCD4884 joy;
int sec=0;
int hourTime = 0;
int minTime = 0;
int hourAlarm = 1;
int minAlarm = 0;
int isAlarm = 0;
int timeNow = 0;
int level = 0;

int wakeUp[3]={0,0,0};
//0 late, 1 not late, 2 set
int addTime(int min);
void plusTime();
int ring(int a);
int alarmNow();
int menu(int n,char *input[]);
void print(int n,unsigned char X, unsigned char Y);
void win();
void lose();
int snake_game();
int crossRoad_game();
int modeA();
int modeB();
int modeC();
int modeD();
int modeE();
int modeF();

int main() {
    t.attach(&plusTime, 1.0);

    int mode = 0,temp;
    char *str[6] = {"watch time","before alarm","set alarm","play games","watch Data","bluetooth"};
    joy.LCD_init();
    /*
    while(1){
        joy.LCD_write_string(0x00,0x00,"aaaaaa",'0');
        //joy.LCD_clear();
    }*/

    while(1) {
        
        temp = menu(6,str);
        switch(temp){
            case 0: modeA();break;
            case 1: modeB();break;
            case 2: modeC();break;
            case 3: modeD();break;
            case 4: modeE();break;
            case 5: modeF();break;
        }
        wait_ms(100);
    }
    //return 0;
}

//time
int addTime(int min){
    minTime += min;
    hourTime += minTime/60;
    hourTime%=24;
    minTime%=60;
    return 0;
}
void plusTime(){
    sec++;
    if(sec==60){
        sec = 0;
        addTime(1);
    }
    if(hourTime==hourAlarm&&minTime==minAlarm){
        alarmNow();
    }
}

//alarm
int isLight(){
    float a;
    a = LDR.read();
    if(a<=0.5) return 1; //สว่าง
    return 0;
}
int ring(int a){
    if(a==1) buzz = 1;
    else buzz = 0;
}
int alarmNow(){                                                             //เพิ่มเชคว่า เลท/ไม่เลท
    me.start();
    int random,light=0,re=0;
    srand(time(NULL));
    random = rand()%2;
    ring(1);
    if(random==1){
        while(!snake_game());
    }else{
        while(!crossRoad_game());
    }
    while(!light){
        light =isLight();
    }
    ring(0);
    isAlarm = 0;
    me.stop();
    if(me.read()>180) wakeUp[0]++;
    else wakeUp[1]++;
}

//modeA = watch time
int modeA(){
    char temp[6],c;
    while(1){
        temp[0] = '0'+hourTime/10;
        temp[1] = hourTime%10+'0';
        temp[2] = '.';
        temp[3] = '0'+minTime/10;
        temp[4] = minTime%10+'0';
        temp[5] = '\0';

        joy.LCD_clear();
        joy.LCD_write_string_big(10,2,temp,0);

        c=joy.LCD_joystick();
        if(c=='l') return -1;
        wait_ms(100);
    }
}

//modeB = before alarm
int modeB(){
    char c,temp[7];
    int a=0,b=0,show;

    while(1){
        joy.LCD_clear();
        if(isAlarm){
            a = hourTime*60 + minTime;
            b = hourAlarm*60 + minAlarm;
            if(a>b){
                show = 24*60 - a + b;
            }else if(a<b){
                show = b-a;
            }
            temp[0] = (show/60)/10 + '0';
            temp[1] = (show/60)%10 + '0';
            temp[2] = '.';
            temp[3] = (show%60)/10 + '0';
            temp[4] = (show%60)%10 + '0';
            temp[5] = '\0';
            joy.LCD_write_string_big(10,2,temp,0);
        }else joy.LCD_write_string_big(10,2,"--.--",0);

        c=joy.LCD_joystick();
        if(c=='l') return -1;
        wait_ms(100);

    }
}

//modeC = set alarm
int modeC(){
    int mode=0;
    int x[2]={0,0};
    char c,temp[6];

    while(1){
        joy.LCD_clear();

        if(mode==0){
            temp[0] = '0'+x[0]/10;
            temp[1] = x[0]%10+'0';
            temp[2] = '\0';
            joy.LCD_write_string_big(7,2,temp,1);
            temp[0] = '0'+x[1]/10;
            temp[1] = x[1]%10+'0';
            temp[2] = '\0';
            joy.LCD_write_string_big(40,2,".",0);
            joy.LCD_write_string_big(47,2,temp,0);
        }else if(mode==1){
            temp[0] = '0'+x[0]/10;
            temp[1] = x[0]%10+'0';
            temp[2] = '\0';
            joy.LCD_write_string_big(7,2,temp,0);
            temp[0] = '0'+x[1]/10;
            temp[1] = x[1]%10+'0';
            temp[2] = '\0';
            joy.LCD_write_string_big(40,2,".",0);
            joy.LCD_write_string_big(47,2,temp,1);
        }

        c=joy.LCD_joystick();
        switch (c){
            case 'l':
                if(mode==1) mode=0;
                else{
                    joy.LCD_clear();
                    joy.LCD_write_string(0,1,"back to menu?",0);
                    joy.LCD_write_string(0,2,"(Y) move Right",0);
                    joy.LCD_write_string(0,3,"(N) move Left",0);
                    while(1){
                        wait_ms(200);
                        c=joy.LCD_joystick();
                        if(c=='l'){
                            break;
                        }else if(c=='r'){
                            return -1;
                        }
                    }
                }
                break;
            case 'r':
                if(mode==0) mode=1;
                else{
                    joy.LCD_clear();
                    joy.LCD_write_string(0,0,"set alarm at",0);

                    temp[0] = '0'+x[0]/10;
                    temp[1] = x[0]%10+'0';
                    temp[2] = '.';
                    temp[3] = '0'+x[1]/10;
                    temp[4] = x[1]%10+'0';
                    temp[5] = '\0';
                    joy.LCD_write_string(20,1,temp,0);

                    joy.LCD_write_string(0,3,"confirm?",0);
                    joy.LCD_write_string(0,4,"(Y) move Right",0);
                    joy.LCD_write_string(0,5,"(N) move Left",0);
                    while(1){
                        wait_ms(200);
                        c=joy.LCD_joystick();
                        if(c=='r'){
                            isAlarm = 1;
                            wakeUp[2]++;
                            hourAlarm = (temp[0]-'0')*10+(temp[1]-'0');
                            minAlarm = (temp[3]-'0')*10+(temp[4]-'0');
                            return 0;
                        }else if(c=='l'){
                            break;
                        }
                    }
                }
                break;
            case 'u':
                switch(mode){
                    case 0: x[0] = (x[0]+1)%24; break;
                    case 1: x[1] = (x[1]+1)%60; break;
                }
                break;
            case 'd':
                switch(mode){
                    case 0: x[0] = (x[0]+23)%24; break;
                    case 1: x[1] = (x[1]+23)%60; break;
                }
                break;
        }
        wait_ms(200);
    }
}

//modeD = play games
int modeD(){
    int mode;
    char *data[2];
    data[0] = "Snake";
    data[1] = "Cross Road";

    mode = menu(2,data);
    wait_ms(100);
    if(mode==0) snake_game();
    else if(mode==1) crossRoad_game();
    return 0;
}

//modeE = watch Data
int modeE(){                                                               
    char c,temp[15];
    int check=0;

    joy.LCD_clear();
    sprintf(temp,"Late : %d",wakeUp[0]);
    joy.LCD_write_string(0,0,temp,0);
    sprintf(temp,"Not Late : %d",wakeUp[1]);
    joy.LCD_write_string(0,1,temp,0);
    sprintf(temp,"Set Alarm : %d",wakeUp[2]);
    joy.LCD_write_string(0,2,temp,0);

    sprintf(temp,"reset move joy");
    joy.LCD_write_string(0,4,temp,0);
    sprintf(temp,"down 2 times.");
    joy.LCD_write_string(0,5,temp,0);
    while(1){
        c=joy.LCD_joystick();
        if(check==1){
            joy.LCD_clear();
            joy.LCD_write_string(0,0,"data reset",0);
            wait(2);
            for(check=0;check<3;check++) wakeUp[check] = 0;
            joy.LCD_clear();
            sprintf(temp,"Late : %d",wakeUp[0]);
            joy.LCD_write_string(0,0,temp,0);
            sprintf(temp,"Not Late : %d",wakeUp[1]);
            joy.LCD_write_string(0,1,temp,0);
            sprintf(temp,"Set Alarm : %d",wakeUp[2]);
            joy.LCD_write_string(0,2,temp,0);
        
            sprintf(temp,"reset move joy");
            joy.LCD_write_string(0,4,temp,0);
            sprintf(temp,"down 2 times.");
            joy.LCD_write_string(0,5,temp,0);
        }
        check = 0;
        if(c=='l') return -1;
        if(c=='d') check++;
        wait_ms(200);
    }
}

//modeF = bluetooth
int modeF(){        //bluetooth mode here
    char input[6],temp[15];
    input[0] = pc.getc();
    input[1] = pc.getc();
    input[2] = pc.getc();
    input[3] = pc.getc();
    input[4] = pc.getc();
    input[5] = '\0';

    switch(input[0]){
        case '0':
            hourTime = (input[1]-'0')*10+(input[2]-'0');
            minTime = (input[3]-'0')*10+(input[4]-'0');
            break;
        case '1':
            isAlarm = 1;
            wakeUp[2]++;
            hourAlarm = (input[1]-'0')*10+(input[2]-'0');
            minAlarm = (input[3]-'0')*10+(input[4]-'0');
            break;
        case '2':
            level = input[1]-'0';
            break;
        case '3':
            sprintf(temp,"%02d%02d%02d",wakeUp[0],wakeUp[1],wakeUp[2]);
            pc.printf(temp);
        break;
        default :                                                           //do some thing
    }

}

// game
void print(int n,unsigned char x, unsigned char y){
    if(n!=0) joy.LCD_pixel(x,y);
}
void win(){
    joy.LCD_clear();
    joy.LCD_write_string(20,2,"WIN!",0);
}
void lose(){
    joy.LCD_clear();
    joy.LCD_write_string(20,2,"LOSE!",1);
}

int snake_game(){
    wait(0.5);
    int map[24][24],num = high*width;
    
    int k,p=0,i,j;
    int pScore,lvl=level,walk,path=1,temp,now;
    int score = 4,food=0;
    char c;
    int input[high][width];
    unsigned char output[num/8];

    srand(time(NULL));
    pScore = (rand()%10)+7;     //pass score here!

    for(i=0;i<high;i++){
        for(j=0;j<width;j++){
            if(j==0||i==0||i==high-1||j==width-1) map[i][j] = -1;
            else map[i][j] = 0;
        }
    }

    map[high/2][width/3] = 1;
    map[high/2][(width/3)+1] = 2;
    map[high/2][(width/3)+2] = 3;
    map[high/2][(width/3)+3] = 4;
    now = ((high/2))*width + (width/3)+3;
    while(map[food/width][food%width]!=0){
        food = rand()%num;              //random food
    }
    
    joy.LCD_clear();
    joy.LCD_write_string(10,1,"move joy to",0);
    joy.LCD_write_string(10,2,">> START <<",0);
    
    while(1){
        wait_ms(200);
        c=joy.LCD_joystick();
        if(c=='u'||c=='d'||c=='l'||c=='r') break;
    }
    wait_ms(200);
    //start game!
    joy.LCD_clear();
    while(1){
        //print map[][] to 0,1
        
        for(i=0;i<high;i++){
            for(j=0;j<width;j++){
                if((i*width + j)==food) input[i][j] = 1;
                else if(map[i][j]!=0) input[i][j] = 1;
                else input[i][j] = 0;
            }    
        }
        
        //change to new Map
        
        p = 0;
        for(i=0;i<72;i++) output[i] = 0;
         
        for(i=0;i<3;i++){
            for(j=0;j<24;j++){
                for(k=7;k>=0;k--){
                    output[p] = output[p]*2 + input[i*8+k][j];
                    //printf("%d ",input[i*8+7-k][j]);
                }
                p++;
            }
        }
        
        joy.LCD_clear();
        joy.LCD_draw_bmp_pixel(0,0,output,high,width);               
        
        wait_ms(200);
        //find path
        c=joy.LCD_joystick();
        switch (c){
            case 'l': temp=-1; break;
            case 'r': temp=1; break;
            case 'u': temp=-width; break;
            case 'd': temp=width; break;
            default : temp=path;
        }
        if(temp!=-path)path=temp;

        if(map[(now+path)/width][(now+path)%width]!=0) break;  //eat !food

        now+=path;
        temp = 1;

        if(now==food){
            score+=1;
            temp = food;
            while(map[food/width][food%width]!=0||food==temp){
                food = rand()%num;              //random food
            }
            map[food/width][food%width] = 1;
            temp=0;
        }
        map[now/width][now%width]=score+1;
        for(i=0;i<num;i++) if(map[i/width][i%width]>0) map[i/width][i%width]-=temp;

        
        wait_ms((maxLvl - lvl+1)*200);
    }

    if((score*lvl)-4>=pScore){
        win();
        wait(2);
        return 1;
    }

    lose();
    wait(2);

    return 0;
}
int crossRoad_game(){
    wait(0.5);
    int car[high][width],num = high*width;
    unsigned char i,j;
    int k,p;
    int pScore,lvl=level,walk,path=0,temp,now;
    int score = 4,isWin=0;
    char c;
    int input[high][width];
    unsigned char output[num/8];

    now = ((high-2))*width + (width/2);
    srand(time(NULL));
    pScore = (rand()%10)+7;     //pass score here!

    for(i=0;i<high;i++){
        for(j=0;j<width;j++){
            if(i==high-1) car[i][j] = -1;
            else if(i==0) car[i][j] = -2;
            else car[i][j] = 0;
        }
    }//set no car

    for(i=1;i<high-2;i++){
        for(j=0;j<((width*((i%2)+1))/10);j++){
            temp = rand()%(width);
            car[i][temp] = 1;
        }
    }//set car

    joy.LCD_clear();
    joy.LCD_write_string(10,1,"move joy to",0);
    joy.LCD_write_string(10,2,">> START <<",0);
    while(1){
        wait_ms(200);
        c=joy.LCD_joystick();
        if(c=='u'||c=='d'||c=='l'||c=='r') break;
    }

    //start game!
    joy.LCD_clear();
    while(1){

        //print map[][] to 0,1
        for(i=0;i<num;i++){
            if(i==now) input[i/width][i%width] = 1;
            else if(car[i/width][i%width]!=0) input[i/width][i%width] = 1;
            else input[i/width][i%width] = 0;
        }
        
        //change to new Map
        p = 0;
        for(i=0;i<72;i++) output[i] = 0;
        for(i=0;i<3;i++){
            for(j=0;j<24;j++){
                for(k=7;k>=0;k--){
                    output[p] = output[p]*2 + input[i*8+k][j];
                    printf("%d ",input[i*8+7-k][j]);
                }
                p++;
            }
        }
        joy.LCD_clear();
        joy.LCD_draw_bmp_pixel(0,0,output,high,width); 
        

        //find path
        c=joy.LCD_joystick();
        switch (c){
            case 'a': path=-1; break;
            case 'd': path=1; break;
            case 'w': path=-width; break;
            case 's': path=width; break;
            default : path=0;
        }

        for(i=1;i<high-2;i++){
            if(i%2==0){ // <<<
                temp = car[i][0];
                for(j=0;j<width-1;j++) car[i][j] = car[i][j+1];
                car[i][width-1] = temp;
            }else{     // >>>
                temp = car[i][width-1];
                for(j=width-1;j>0;j--) car[i][j] = car[i][j-1];
                car[i][0] = temp;
            }
        }//car walk

        if(path*path==1){      //L,R
            if(now+path<0){
                if((now+width)/width < (now+width+path)/width) now -= width;
                else if((now+width)/width>(now+width+path)/width) now += width;
            }else{
                if((now)/width<(now+path)/width) now -= width;
                else if((now)/width>(now+path)/width) now += width;
            }
        }

        now+=path;

        if(isWin==1) break;
        if(car[now/width][now%width]==-2) isWin = 1;
        else if(car[now/width][now%width]==-1) now-=path;
        else if(car[now/width][now%width]==1) break;

        path = 0;
        
        
        wait_ms((maxLvl - lvl+1)*200);
    }
    if(isWin){
        win();
        wait(2);
        return 1;
    }

    lose();
    wait(2);

    return 0;
}
int menu(int n, char *input[]){
    wait_ms(100);
    int i;
    int mode = 0;
    char c;
    while(1){
        joy.LCD_clear();
        for(i=0;i<n;i++){
            if(mode==i){
                joy.LCD_write_string(0,i,input[i],1);
            }else{
                joy.LCD_write_string(0,i,input[i],0);
            }
        }


        c=joy.LCD_joystick();
        if(c=='r') break;
        switch(c){
            case 'u': if(mode!=0) mode--;
               break;
            case 'd': if(mode!=n-1) mode++;
                break;
            case 'l': return -1;
                break;
        }
        wait_ms(200);
    }
    wait_ms(200);
    return mode;
}
