#include "mbed.h"
#include "DS1307.h"
#include "DigitDisplay.h"
#include "Game.h"

DS1307 myrtc(I2C_SDA,I2C_SCL);
DigitDisplay display(D7,D8);
Game game;
DigitalOut buzzer(D6);
BusIn b(D9,D10,D11);
BusOut led(D2,D3,D4,D5);
AnalogIn analog_value(A2);
const bool bcd[16][4] = {{0,0,0,0},{0,0,0,1},{0,0,1,0},{0,0,1,1},{0,1,0,0},{0,1,0,1},{0,1,1,0},{0,1,1,1},
                         {1,0,0,0},{1,0,0,1},{1,0,1,0},{1,0,1,1},{1,1,0,0},{1,1,0,1},{1,1,1,0},{1,1,1,1}};

void DisplayTime();

int mode=0;
int main() 
{
   b.mode(PullUp);
   int p_ldr=0,cr_ldr=0,sn=0,j=0;
   int sec=0,min=39,hour=21,day=19,date=7,month=12,year=15;
   int n=0,opt=1,p=0,ten_hour,nu_hour,ten_min,nu_min,hour_a=7,min_a=0;
   float mea;
   int state=0, wrong=0;
   int hexnum[4],game2num[10],game2level=5;
   int currenthex=0, checkbcd=0, gameround=0, changehex=1, changenum=1,currentnum=0,checkloop=0;
   bool imawake=0;
   int fix=0,match=0,fail=1,delay=0,i;
        
   //myrtc.settime(sec,min,hour,day,date,month,year);
   //DisplayTime();
   //display.Displayset((hour-(hour%10))/10,hour%10,(min-(min%10))/10,min%10);
   while(1)
   {  
      myrtc.gettime(&sec,&min,&hour,&day,&date,&month,&year);
      //state=2;
      if(state==0)
            {
                if(sn==0){led=0b0001;}
                if(sn==1){led=0b0011;}
                if(sn==2){led=0b0111;}
                if(sn==3){led=0b1111;}
                printf("In state1\n");
                printf("houra/mind = %d  :  %d",hour,min);
                mea=analog_value.read();
                if(b==0b011){n=1;}
                else if(b==0b101){n=2;}
                else if(b==0b110){n=3;}
                else n=0;
                display.getButtonState(n);
        
                wait_ms(100);
        
                //printf("%d\n",mode);
        
                wait_ms(100);
        
                if(display.checkButton3()==1)
                {
                    p++;
                    if(p==10){p=0;}
                    printf("%d\n",p);
                    if(p%2==0){opt=1;}
                    if(p%2==1){opt=2;}
                }
        
                if(opt==1)
                {
                    display.setColon(1);
                    display.Displayset((hour-(hour%10))/10,hour%10,(min-(min%10))/10,min%10);           
                }
                if(opt==2)
                {
                    ten_hour=(hour_a-(hour_a%10))/10;
                    nu_hour=hour_a%10;
                    ten_min=(min_a-(min_a%10))/10;
                    nu_min=min_a%10;
                    display.Displayset(ten_hour,nu_hour,ten_min,nu_min);
        
                    if(display.checkButton1()==1){hour_a++;}
                    if(display.checkButton2()==1){min_a=min_a+5;}
             
                    if(hour_a==24){hour_a=0;}
                    if(min_a==60){min_a=0;}
             
                }
                if(hour==hour_a&&min==min_a&&imawake==0){buzzer=1; state=1;printf("wait check");}
                else if(imawake==1 && min!=min_a) imawake=0;
            }
        
        
        if(state==1)
        {
            //####SNOOZE##
            mea=analog_value.read();
            if(mea<0.65){cr_ldr=0;}
            if(mea>=0.65){cr_ldr=1;}
            
            printf("%f",mea);
            
            wait_ms(100);
            printf("%d   :  %d\n",p_ldr,cr_ldr);
            if(b==0b011){n=1;}
                else if(b==0b101){n=2;}
                else if(b==0b110){n=3;}
                else n=0;
                display.getButtonState(n);
            
            if(sn<3 && p_ldr==0 && cr_ldr==1)
            {
                buzzer=0;
                sn++;
                if(min_a<55){min_a = min_a+5;state=0;}
                else if(min_a>=55){min_a = (min_a+5)%60 ; hour_a=hour_a+1;state=0;}
                printf("In loop");
            }
            
            printf("h/m    %d : %d\n",hour,min);
            printf("h_a/h_m                       %d : %d\n",hour_a,min_a);
            printf("state : %d\n",state);
            printf("snooze  :  %d",sn);
            if(display.checkButton1()==1||display.checkButton2()==1||display.checkButton3()==1){state=2;}
            
            p_ldr=cr_ldr;
            if(sn==0){led=0b0001;}
            if(sn==1){led=0b0011;}
            if(sn==2){led=0b0111;}
            if(sn==3){led=0b1111;}
            }
            
        if(state==2)
        {
            mea=analog_value.read();
            //state = 1;
            int gameRandom = (int)(analog_value.read())%3;
            if(gameRandom==0)
            {
                if(b==0b011){n=1;}
                else if(b==0b101){n=2;}
                else if(b==0b110){n=3;}
                else n=0;
        
                if(sn==0){delay=5000;}
                if(sn==1){delay=4500;}
                if(sn==2){delay=4000;}
                if(sn==3){delay=3500;}
                
                if(fail==1)
                {
                    fix=(int(mea*1000))%99;
                    fail=0;
                }
                match++;
                if(match==100){match=0;}
            
                for(i=0;i<delay;i++)
                {
                        display.Displayset((fix-(fix%10))/10,fix%10,(match-(match%10))/10,match%10);
                        display.getButtonState(n);
                        if(display.checkButton1()==1)
                    {
                        
                        if(fix==match||fix-match==1||match-fix==1){fail=1;gameround++;display.A();}
                        else{fail=1;display.F();}
                        wait_ms(100);
                        i=delay;
                        match=0;
                        if(gameround==3){gameround=0;buzzer=0;state=0;imawake=1;sn=0;break;}
                    }
                }
                
        }
        //######################
            if(gameRandom==1)
            { 
                if(wrong>3) game2level = 10;
                else if(sn==0) game2level = 5;
                else if(sn==1) game2level = 6;
                else if(sn==2) game2level = 7;
                else if(sn==3) game2level = 8;
                if (changenum==1)
                {
                    for(int i=0;i<game2level;i++)
                    {
                        game2num[i] = (int)(analog_value.read()*1000)%3+1;
                    }
                    for(int i=0;i<game2level;i++)
                    {
                        display.Displayset(0xFF,0xFF,game2num[i],0xFF);
                        wait_ms(400);
                        display.Displayset(0xFF,0xFF,0xFF,0xFF);
                        wait_ms(80);
                        changenum=0;
                    }
                }
                checkloop++;
                if(checkloop==60)
                {
                    for(int i=0;i<game2level;i++)
                    {
                        display.Displayset(0xFF,0xFF,game2num[i],0xFF);
                        wait_ms(400);
                        display.Displayset(0xFF,0xFF,0xFF,0xFF);
                        wait_ms(80);
                        checkloop=0;
                        currentnum= 0;
                    }
                }
                display.Displayset(0xFE,0xFE,0xFE,0xFE);
                if(b==0b011){n=1;}
                else if(b==0b101){n=2;}
                else if(b==0b110){n=3;}
                else n=0;
                display.getButtonState(n);
                wait_ms(100);
                if((game2num[currentnum]==1 && display.checkButton1()==1)||(game2num[currentnum]==2 && display.checkButton2()==1)||(game2num[currentnum]==3 && display.checkButton3()==1))
                {
                    if(currentnum<game2level-1) {currentnum++; printf("-_-\n");}
                    else
                    {
                        printf("YEAH\n");
                        gameround++;
                        changenum = 1;
                        currentnum= 0;
                        display.A();
                        
                    }
                }
                else if((game2num[currentnum]==1 && (display.checkButton2()==1||display.checkButton3()==1))||(game2num[currentnum]==2 && (display.checkButton1()==1||display.checkButton3()==1))||(game2num[currentnum]==3 && (display.checkButton1()==1||display.checkButton2()==1)))
                {
                    currentnum=0;
                    wrong++;
                    changenum = 1;
                    display.F();
                }
                if(gameround==4) 
                {
                    printf("eiei\n");
                    mode=1;
                    state=0;
                    wrong=0;
                    buzzer=0;
                    game2level=5;
                    currentnum=0;
                    gameround=0;
                    changenum=1;
                    imawake=1;
                    sn=0;
                }
            }  
            //########################################
            else if(gameRandom==2)
            {
                int gamelevel=game.getlevel();
                if(changehex==1)
                {
                    for(int i=0;i<gamelevel;i++)
                    {
                        mea=analog_value.read();     
                        hexnum[i] = game.randomHex(mea);
                    }
                    if(gamelevel==1) display.Displayset(0xFF,0xFF,hexnum[0],0xFF);
                    else if(gamelevel==2) display.Displayset(0xFF,hexnum[0],hexnum[1],0xFF);
                    else if(gamelevel==3) display.Displayset(0xFF,hexnum[0],hexnum[1],hexnum[2]);
                    else if(gamelevel==4) display.Displayset(hexnum[0],hexnum[1],hexnum[2],hexnum[3]);
                    changehex = 0;
                }
                if(b==0b011){n=1;}
                else if(b==0b101){n=2;}
                else if(b==0b110){n=3;}
                else n=0;
                display.getButtonState(n);
                wait_ms(100);
                if((bcd[hexnum[currenthex]][checkbcd]==0 && display.checkButton1()==1)||(bcd[hexnum[currenthex]][checkbcd]==1 && display.checkButton2()==1))
                {printf("**%d\t%d\n",hexnum[currenthex],checkbcd);
                    if(checkbcd<3) {checkbcd++; printf("-_-\n");}
                    else
                    {printf("4\n");
                        checkbcd=0;
                        currenthex++;
                        if(currenthex==gamelevel) 
                        {printf("YEAH\n");
                            gameround++;
                            changehex = 1;
                            currenthex = 0;
                            display.A();
                        } 
                    }
                }
                else if((bcd[hexnum[currenthex]][checkbcd]==1 && display.checkButton1()==1)||(bcd[hexnum[currenthex]][checkbcd]==0 && display.checkButton2()==1))
                {printf("**%d\t%d\n",hexnum[currenthex],checkbcd);
                    printf("bu\n");
                    checkbcd=0;
                    game.pluslevel();
                    currenthex=0;
                    changehex = 1;
                    display.F();
                }
                
                if(gameround==4) 
                {
                    printf("eiei\n");
                    mode=1;
                    state=0;
                    buzzer=0;
                    game.resetlevel();
                    checkbcd=0;
                    currenthex=0;
                    gameround=0;
                    changehex=1;
                    imawake=1;
                    sn=0; 
                }
            }
            
        }
        
        //printf("%f\n",mea);
        //if(mea>=0.65){min_a=min_a+1;}
        
   }
}