#include "mbed.h"
#include "DS1307.h"


DS1307::DS1307(PinName sda,PinName scl):rtc(sda,scl){}
void DS1307::settime(int sec,int min,int hour,int day,int date,int month,int year)
{
    char data[7][2] = { {0x00, dectobcd(sec)},
                        {0x01, dectobcd(min)},
                        {0x02, dectobcd(hour)},
                        {0x03, dectobcd(day)},
                        {0x04, dectobcd(date)},
                        {0x05, dectobcd(month)},
                        {0x06, dectobcd(year)}  };
    int i;
    for(i=0;i<7;i++)
        {
            rtc.write(DS1307_ADDRESS, data[i], 2);
        }
}
void DS1307::gettime(int *sec,int *min,int *hour,int *day,int *date,int *month,int *year)
{
    char j = 0;
    char data[7];
    int i;
    for(i=0;i<7;i++)
        {
            rtc.write(DS1307_ADDRESS, &j, 1);
            rtc.read(DS1307_ADDRESS, &data[i], 1);
            j++;
        }
     *sec=bcdtodec(data[0]);
     *min=bcdtodec(data[1]);
     *hour=bcdtodec(data[2]);
     *day=bcdtodec(data[3]);
     *date=bcdtodec(data[4]);
     *month=bcdtodec(data[5]);
     *year=bcdtodec(data[6]);
}
int DS1307::bcdtodec(int num) 
{    
    return 10*(num/16) + num % 16; 
}
int DS1307::dectobcd(int num) 
{
    return 16*(num/10) + num % 10; 
}