/* 
Simple library for the SparkFun Ardumoto Shield https://www.sparkfun.com/products/9815
with the ST Nucleo F401RE
 
The SparkFun Ardumoto shield can control two DC motors (up to 2 amps per motor). It is based on the L298 H-bridge. 

Developped by : Didier Donsez & Jérome Maisonnasse
 
 License: CC-SA 3.0, feel free to use this code however you'd like.
 Please improve upon it! Let me know how you've made it better.
 
 This is really simple example code to get you some basic functionality with the Ardumoto Shield.
 
 */

#include "ArduMotoShield.h"
#include "mbed.h"

// depend of the Vin and the max voltage of the motors
float MAXPWM = 0.5f;
                
#define LOW 0
#define HIGH 1

//DigitalOut inApin(D12, LOW); //direction control for motor outputs 1 and 2 is on digital pin 12
//DigitalOut inBpin(D13, LOW); //direction control for motor outputs 3 and 4 is on digital pin 13
BusOut inApin(D11,D12);
BusOut inBpin(D13,D14);
PwmOut pwmApin(D3); //PWM control for motor outputs 1 and 2 is on digital pin 3
PwmOut pwmBpin(D5); //PWM control for motor outputs 3 and 4 is on digital pin 11

bool isSetup=false;

void ArduMotoShield::setVoltages(float vin, float vmaxmotor)
{  

    if(vin<vmaxmotor)
        MAXPWM=1.0f;
    else
        MAXPWM=vmaxmotor/vin;
}


void ArduMotoShield::setup()
{  
    pwmApin.period_ms(10);
    pwmApin.pulsewidth_ms(1);
    pwmApin.write(0.0f);

    pwmBpin.period_ms(10);
    pwmBpin.pulsewidth_ms(1);  
    pwmBpin.write(0.0f);
    
    isSetup=true;        
}

// Basic ArduMotoShield operations

void ArduMotoShield::forward(float A_PWM,float B_PWM) //full speed forward
{ 
        if(!isSetup) setup();

        //inApin.write(LOW);
        //inBpin.write(LOW);
  
        inApin=1;
        inBpin=1;
        pwmApin.write(A_PWM);//(MAXPWM);
        pwmBpin.write(B_PWM);//(MAXPWM);
        //printf("Forward : %.2f\n",AnaPWM);
}

void ArduMotoShield::backward(float A_PWM,float B_PWM) //full speed backward
{
        if(!isSetup) setup();

        //inApin.write(HIGH);
        //inBpin.write(HIGH);

        inApin=2;
        inBpin=2;
        pwmApin.write(A_PWM);//(MAXPWM);
        pwmBpin.write(B_PWM);//(MAXPWM);
        //printf("Backward\n");
}

void ArduMotoShield::right(float A_PWM,float B_PWM)
{
        if(!isSetup) setup();

        //inApin.write(HIGH);
        //inBpin.write(LOW);
  
        inApin=1;
        inBpin=2;
        pwmApin.write(A_PWM);//(MAXPWM);
        pwmBpin.write(B_PWM);//(MAXPWM);
        //printf("Right\n");
}

void ArduMotoShield::left(float A_PWM,float B_PWM)
{
        if(!isSetup) setup();

        //inApin.write(LOW);
        //inBpin.write(HIGH);
   
        inApin=2;
        inBpin=1;
        pwmApin.write(A_PWM);//(MAXPWM);
        pwmBpin.write(B_PWM);//(MAXPWM);
        //printf("Left\n");
}

void ArduMotoShield::stop()
{
        if(!isSetup) setup();

        //inApin.write(LOW);
        //inBpin.write(LOW);
  
        inApin=0;
        inBpin=0;
        pwmApin.write(0.0f);
        pwmBpin.write(0.0f);
        //printf("Stop\n");
}