#include "mbed.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);
//AnalogIn analog_value(A1);
DigitalOut colO[4]={D5,D4,D3,D2};
DigitalIn roll1(D6,PullDown);
DigitalIn roll2(D7,PullDown);
DigitalIn roll3(D8,PullDown);
DigitalIn roll4(D9,PullDown);
I2C i2c_lcd(I2C_SDA,I2C_SCL); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2); 
Timer t1;//TIme keypad
Timer t2;//Time Lcd
Timer sampling;//Sampling timer
volatile int Hz = 196000;//defult sampling
volatile int rate_sampling_us = (1000000/Hz);//convert to microsecond
volatile int begin;


AnalogIn RawValue(A1);
SPI device(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut cs(D10);

int count;
int cleck=1;
int screen = 1;
int test = 1;
void getKeypad();
double getvolt(); // get Voltage value ;unit(VOLT)
double getAmp();  //get Amp value unit(AMP)
void read();


volatile double current=0;
double I_peak=0;
volatile double volt=0;
double V_peak=0;
double power=0;
//float meas;
int enter1 = 0;
int data[7] = {0} ;
int dLength = 0;//data length
int dataHz = 100000;
int main()
{
    pc.baud(9600);//1104000
    //pc.printf("Start\n");
    
    t1.start();
    t2.start();
    count=0;
    lcd.printf("Welcome !!!");
    sampling.start();
    
    for(count=0;count<4;count++)
    {
        colO[count]=0;
    }
    count=0; 
    while(1)
    {
        //meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        //meas = meas * 3300;
       // pc.printf("%f\n",meas);
       begin = sampling.read_us();
       if(begin >= rate_sampling_us)  //read sensor
       {
        read();
        sampling.reset();
       }
            if(current<0)
            {current=0;}
            power=current*volt;
            if(current>=I_peak)
            {
                I_peak=current;
            }
            if(volt>=V_peak)
            {
                V_peak=volt;
            }
            pc.printf("#%.3f,%.3f,%.3f*\n",power,current,volt);
            
    getKeypad();
    enter1=0;
    if(t2.read_ms() > 500)
    {
        
        if(screen==6)
        {
            screen=1;
        }
        else if(screen==0)
        {
            screen=5;
        }
        
        if(screen==1)
        {//enter1=0;
            lcd.cls();
            lcd.printf("Power   %3.3f W",power);
        }
        else if(screen==2)
        {//enter1=0;
            lcd.cls();
            lcd.printf("Current  %.3f AI_Peak   %.3f A",current,I_peak);
        }
        else if(screen==3)
        {//enter1=0;
            lcd.cls();
            lcd.printf("Volt     %.3f VV_Peak   %.3f V",volt,V_peak);
        }
        else if(screen==4)
        {
            lcd.cls();
            lcd.printf("Sampling\n%d Hz",Hz);
            
        }
        else if(screen==5)
        {
            dLength=0;
            enter1=1;
            lcd.cls();
            lcd.printf("Gen Sampling(Hz)");
            while(screen==5)
            {
                
                if(dLength>7)
                {
                    int i = 0;
                    for(i=0;i<8;i++)
                    {
                     data[i]=0;   
                    }
                    dLength=0;
                    
                     lcd.cls();
                     lcd.printf("Gen Sampling(Hz)");
                     lcd.printf("Please 0-1m");
                     wait(1);
                     lcd.cls();
                     lcd.printf("Gen Sampling(Hz)");
                }
                getKeypad();
            }
            
        }
        t2.reset(); 
    }
    if(t1.read_ms() > (1000*1000))
        {
         t1.reset();   
        }
    }
    
}


//D2, D3, D4, D5, D6, D7, D8, D9
/*
|1 2 3 up   |
|4 5 6 down | 
|7 8 9 enter|
|0 0 0 clear|
*/

void getKeypad(){

        if(count==0)
        {
            colO[3]=0;
            colO[count]=1;
        }
        else
        {
            colO[count-1]=0;
            colO[count]=1;
        }
        if(t1.read_ms() >300)
        {
            cleck=1;
        }
        //pc.printf("%d\n",i);
        if(roll1==1&&colO[0]==1&&cleck==1)//s1 up
        {
        screen--;
        cleck=0;
        t1.reset();
        }
        else if(roll1==1&&colO[1]==1&&cleck==1)//s2 down
        {
        screen++;
        cleck=0;
        t1.reset();
        }
        else if(roll1==1&&colO[2]==1&&cleck==1)//s3 enter
        {
            if(enter1==1)
            {
                if(dLength>0)
                {   int j = dLength-1;//loop
                    int k = data[j];//data*something
                    int l = 1;
                    dataHz=0;
                    //lcd.printf("%d",k);
                    for(j = dLength-1;j>=0;j--)
                    {
                        data[j]=k;
                        l=(l*10);
                        if(j>=0)
                        {
                        k=(data[j-1]*l);
                        }
                        
                        dataHz=dataHz+data[j];
                    }
                    for(l=0;l<8;l++)
                    {
                     data[l]=0;   
                    }
                    dLength=0;
                    if(dataHz==0||dataHz>1000000)
                    {
                        dataHz=100000;
                        lcd.cls();
                     lcd.printf("Gen Sampling(Hz)");
                     lcd.printf("Please 0-1m");
                     wait(1);
                    }
                    
                    Hz=dataHz;
                    rate_sampling_us = (1000000/Hz);
                    
                    lcd.cls();
                lcd.printf("Gen Sampling(Hz)");
                lcd.printf("OK !!!");
                wait(1);
                
                    
                }
                //lcd.printf(" ");
                
                lcd.cls();
            lcd.printf("Gen Sampling(Hz)");
            }
        cleck=0;
        t1.reset();
        }
        else if(roll1==1&&colO[3]==1&&cleck==1)//s4 clear
        {
            if(enter1==1)
            {
                int m;
                for(m=0;m<8;m++)
                    {
                     data[m]=0;   
                    }
            lcd.cls();
            lcd.printf("Gen Sampling(Hz)");
            dLength=0;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll2==1&&colO[0]==1&&cleck==1)//s5 3
        {
            
            if(enter1==1)
            {
                lcd.printf("3");
                data[dLength]=3;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll2==1&&colO[1]==1&&cleck==1)//s6 6
        {
            if(enter1==1)
            {
                lcd.printf("6");
                data[dLength]=6;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll2==1&&colO[2]==1&&cleck==1)//s7 9
        {
            if(enter1==1)
            {
                lcd.printf("9");
                data[dLength]=9;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll2==1&&colO[3]==1&&cleck==1)//s8
        {
        cleck=0;
        t1.reset();
        }
        else if(roll3==1&&colO[0]==1&&cleck==1)//s9 2
        {
            if(enter1==1)
            {
                lcd.printf("2");
                data[dLength]=2;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll3==1&&colO[1]==1&&cleck==1)//s10 5
        {
            if(enter1==1)
            {
                lcd.printf("5");
                data[dLength]=5;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll3==1&&colO[2]==1&&cleck==1)//s11 8
        {
            if(enter1==1)
            {
                lcd.printf("8");
                data[dLength]=8;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll3==1&&colO[3]==1&&cleck==1)//s12 0
        {
            if(enter1==1)
            {
                lcd.printf("0");
                data[dLength]=0;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll4==1&&colO[0]==1&&cleck==1)//s13 1
        {
        if(enter1==1)
            {
                lcd.printf("1");
                data[dLength]=1;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll4==1&&colO[1]==1&&cleck==1)//s14 4
        {
            if(enter1==1)
            {
                lcd.printf("4");
                data[dLength]=4;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll4==1&&colO[2]==1&&cleck==1)//s15 7
        {
            if(enter1==1)
            {
                lcd.printf("7");
                data[dLength]=7;
                dLength++;
            }
        cleck=0;
        t1.reset();
        }
        else if(roll4==1&&colO[3]==1&&cleck==1)//s16
        {
        cleck=0;
        t1.reset();
        }
        
        count++;
        if(count==4)
        {
            count=0;   
        }
    }

double getvolt() // get Voltage value ;unit(VOLT)
{
    uint16_t  value0[3];
    float volt,sval0;
    cs=1; //slave select
    
    cs=0;
        value0[0] = device.write(0xD0); //read CH0
        value0[1] = device.write(0x00);
        value0[2] = device.write(0x00);
        cs=1;
        
        value0[0] = (value0[0] & 0x07)<<9;//convert to 12bit
        value0[1] = (value0[1] & 0xFF)<<1;
        value0[2] = (value0[2] & 0x80)>>7;
        
        sval0 = value0[0]|value0[1]|value0[2];//sum bit
        
        
        volt = (sval0/4095)*5; //calculate ;volt
        return volt;
}

double getAmp() //get current ;unit(AMP)
{
    char buffer[50] = "/0";
    float Ampoffset = 2.5;//use positive current
    float mVperAmp = 0.1; //typical set
    float Voltage;
    float Amp,val;
    
    val = ((RawValue.read()*((3.3/5)* 1023))+17);//read anaog value
    sprintf(buffer,"%.0f",val); //convert to integer
    val = (float)atof(buffer);
    //pc.printf("%f\n",val);
    Voltage = (5*val)/1023;//calculate to Vin
       sprintf(buffer,"%.3f",Voltage);//convert to integer
       Voltage = (float)atof(buffer);
    
    Amp = (Voltage-2.5)/0.1; //calculate to Amp
    
    return Amp;
    }
    
void read()
{
    current = getAmp();
    volt = getvolt(); 
}
