#include "mbed.h"
#include "DHT22.h"
#include "DS1307.h"
#include "DigitDisplay.h"

//+ADDR:98d3:31:504589
DS1307 rtc(I2C_SDA,I2C_SCL);
Serial Master_to_Slave(PA_11,PA_12 );
DigitDisplay display(D7,D8);
AnalogIn  lightsensor(A3);
Ticker flipper;

DigitalOut LEDOUT1(D2);
DigitalOut LEDOUT2(D3);
DigitalOut LEDOUT3(D4);
DigitalOut LEDOUT4(D5);
DigitalOut buzzer(D6);
DHT22 hum_temp(D9);

void Sunny();
void DHT22();
void lightLDR();
void realtime();
void Augur_Rain();
void Senddata();
void printf_data();

int test_hum=3,test_light = 3500;
int rain_hum_bf=0,rain_hum_af=0,Sum=0,rain_drop=0,Send_light=0;
float Analog,temp,hum;
float Max_temp,Max_hum,Max_light;
int sec=00,mins=8,hour=23,day=01,date=8,month=12,year=15,done=0;
int sec_new,mins_new,hour_new,day_new,date_new,month_new,year_new;

void Sunny()
{
    DHT22();//วัดอุหภูมินในอากาศกับความชื้น
    lightLDR();//ค่าแสงที่ได
    Augur_Rain();//พยากรณ์ฝน
    printf_data();//ออกมาทาง PC
    LEDOUT4=1;
    //printf("%d\n",hour_new);
    if(hour_new >= 6 && hour_new <= 18 ) {
        LEDOUT2=1;
        LEDOUT3=0; //สถานะของ LED

        //DHT22();//วัดอุหภูมินในอากาศกับความชื้น
        //lightLDR();//ค่าแสงที่ได
        //Augur_Rain();//พยากรณ์ฝน
        //printf_data();//ออกมาทาง PC
        //Senddata();




    } else {

        //printf("Sleeping guy \n");
        LEDOUT3=1;
        LEDOUT2=0;
    }


}

void  DHT22()
{

    if(hum_temp.readData() == DHT_ERROR_NONE) done=1;
    {
        temp = hum_temp.getTemperatureC();
        hum = hum_temp.getHumidity();


    }

    if(temp > Max_temp) {
        Max_temp=temp;
    }
    if(hum > Max_hum) {
        Max_hum=hum;
    }
    if(hour_new > 18) {
        Max_temp=0;
        Max_hum=0;
    }

}
void lightLDR()
{
    Analog=lightsensor.read();
    Analog=Analog*5000;

    if(Analog < 700 ) {
        Send_light=1;  //มีแสงง
    } else {
        Send_light=0;//ไม่มีแสงหรือมีแสงน้อย
    }


    if(Analog > Max_light) {
        Max_light=Analog;
    }
    if(hour_new > 17) {
        Max_light=0;
    }



}
void Augur_Rain()
{

    if(mins_new == 5) {
        rain_hum_af=hum;
        //rain_hum_af=78;
    }
    if(mins_new == 10) {
        rain_hum_bf=hum;
    }
    if(mins_new == 15) {
        rain_hum_af=hum;
    }
    if(mins_new == 20) {
        rain_hum_bf=hum;
    }
    if(mins_new == 25) {
        rain_hum_af=hum;
    }
    if(mins_new == 30) {
        rain_hum_bf=hum;
    }
    if(mins_new == 35) {
        rain_hum_af=hum;
    }
    if(mins_new == 40) {
        rain_hum_bf=hum;
    }
    if(mins_new == 45) {
        rain_hum_af=hum;
    }
    if(mins_new == 50) {
        rain_hum_bf=hum;
    }
    if(mins_new == 55) {
        rain_hum_af=hum;
    }
    if(mins_new == 0) {
        rain_hum_bf=hum;
        rain_hum_af=0;
        //rain_hum_bf=75;

    }

    Sum=rain_hum_bf - rain_hum_af;//ค่าที่ได้ออกมาถ้าห่างกัน2-3ผมอาจจะตกตามที่วัดจากของจิง

    //test_hum=3,test_light = 3500;
    //Sum=test_hum;
    //Analog=test_light;

    if(((Sum >=-5 && Sum <= -3) || (Sum >= 3  && Sum <= 5)) &&  (Analog > 1500 && Analog <= 5000) ) {
        rain_drop=1;//อีกประมาณ5-30นาทีฝนตก
        LEDOUT1=1;
    } else {
        rain_drop=0;//ฝนไม่ตก
        LEDOUT1=0;
    }
    if(hour_new > 18) { 
        //Sum=0;
    }
}
void Senddata()
{

    Master_to_Slave.printf("%.2d%.2d%.1f%.1f%.1d%.1d\n",hour_new,mins_new,temp,hum,Send_light,rain_drop);

}
void printf_data()
{
    printf("time            :: %d:%d  \n",hour_new,mins_new);
    printf("Temperature     :: %f C \n",temp);
    printf("Humidity        :: %f g/m3\n",hum);
    printf("Light  by LDR   :: %f\n",Analog);
    //printf("Max_Temperature :: %f C \n",Max_temp);
    // printf("Max_Humidity    :: %f g/m3\n",Max_hum);
    // printf("Max_Light       :: %f\n",Max_light);
    printf("light           :: %d \n",Send_light);
    printf("Sum             :: %d \n",Sum);
    printf("Rain_drop       :: %d \n",rain_drop);
    printf("Sendata M TO SL :: %.2d%.2d%.1f%.1f%.1d%.1d\n\n",hour_new,mins_new,temp,hum,Send_light,rain_drop);
}
void realtime()
{
    rtc.gettime(&sec_new,&mins_new,&hour_new,&day_new,&date_new,&month_new,&year_new);
    rtc.displays();

}
void flip()
{
    //if(hour_new >= 6 && hour_new <= 18 )
    //{Senddata();}
    Senddata();
}

int main()
{

    rtc.settime(sec,mins,hour,day,date,month,year);
    flipper.attach(&flip, 10.0);

    while(1) {


        realtime();
        Sunny();


    }
}
