#define PeriodUpdate 100

#include "mbed.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);                            // set for degugging

Serial bt(PA_9, PA_10);                             //Bluetooth : Tx Rx
InterruptIn encoder(PB_3);                          //Encoder : Set interrupt
PwmOut Motor(PB_5);                                 //Motor   : command motor
InterruptIn button(PC_4);                           //Motor Drive : User button to set running state
AnalogIn currentSS(PA_0);                           //CurrentSensor :
SPI mcp3202(SPI_MOSI, SPI_MISO, SPI_SCK);           //Voltage Sensor ADC MCP3202
DigitalOut cs3202a(PB_6);                           //chip select for mcp3202
DigitalOut cs3202b(PC_7);                           // chip select for mcp3202 nember 2
DigitalIn SwLCD(PB_13);                             //Switch LCD Display
I2C i2c_lcd(I2C_SDA,I2C_SCL);                       // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2);  // I2C bus, PCF8574 addr, LCD Type, Ctrl Type

void getRPM();
void countEncoder();
float getVolt();
float getCurr();
float Display();
void switchRunning();
void dataIn();
void updateData();

float maxVolt=0,maxCurr=0,maxPower=0,volt=0,curr=0,powerMotor =125;
uint8_t countEn=0;
uint16_t rpm=0,maxRPM=0,loopCount=0;
bool runState=0;

int main()
{
    //Prepare
    bt.baud(9600);
    pc.baud(9600);
    bt.attach(&dataIn);                 //Interupt when recieved data
    encoder.rise(&countEncoder);        //set encoder detect rise edge
    button.rise(&switchRunning);        //set user button (blue) to switch running mode
    Motor.period(0.002f);               //set pwm frequency to 500 Hz
    mcp3202.frequency(1000000);         //set SPI mcp3202
    mcp3202.format(8,0);                //set SPI mcp3202
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.cls();

    while(1) {

        if(runState) {  //running loop
            Motor = powerMotor/100.0f;
            curr+=getCurr();
            volt+=getVolt();

        } else {
            Motor = 0.0f;
        }

        if(loopCount>=PeriodUpdate) {
            
            curr/=loopCount;
            volt/=loopCount;
            
            getRPM();
            if(rpm>maxRPM)
                maxRPM=rpm;

            if(volt > maxVolt)
                maxVolt = volt;
            if(curr > maxCurr)
                maxCurr = curr;
            if(curr*volt > maxPower)
                maxPower = curr*volt;

            updateData();
            loopCount=0;
        }

        wait_ms(1);
        loopCount++;
    }
}

void switchRunning()
{
    runState = !runState;
}

void dataIn()
{
    char inTmp[5]= {0};

    for(uint8_t i=0; i<5; i++) {
        inTmp[i] = bt.getc();
        if(inTmp[i] == '\n') break;
    }

    //pc.printf("s %s\td%d \n",inTmp,atoi(inTmp+2));
    powerMotor = atoi(inTmp+2);
    return ;
}

void updateData()
{
    //LCD state 1
    if(SwLCD)
        lcd.printf("RPM:%5d P:%1.2fMax:%5d  :%1.2f",rpm,volt*curr,maxRPM,maxPower);
    //LCD state2
    else
        lcd.printf("V:%1.2fV I:%4.0fmAMx:%1.2fV :%4.0fmA",volt,curr*1000,maxVolt,maxCurr*1000);

    if(!runState) {
        volt =0;
        curr =0;
        rpm =0;
    }
    bt.printf("s %d\nv %.2f\ni %.2f\np %.2f\n",rpm,volt,curr*1000,volt*curr);
}

void getRPM()
{
    if(runState)
        rpm = (countEn/2.0f)/(PeriodUpdate/60000.0f);
    countEn=0;
}

void countEncoder()
{
    countEn++;
}

float getVolt()
{
    uint8_t spi_data[3]= {0};
    cs3202a=0;
    spi_data[0] = mcp3202.write(0x01);
    wait_us(1);
    spi_data[1] = mcp3202.write(0x20);
    spi_data[2] = mcp3202.write(0);
    wait_us(1);
    cs3202a=1;

    return (float)(((spi_data[1]&0x0F)*256.0f)+spi_data[2])/819.0f;
}

float getCurr ()            //mesure current by voltage during R 1 ohm
{
    uint8_t spi_data[3]= {0};
    cs3202b=0;
    spi_data[0] = mcp3202.write(0x01);
    wait_us(1);
    spi_data[1] = mcp3202.write(0x20);
    spi_data[2] = mcp3202.write(0);
    wait_us(1);
    cs3202b=1;

    return (float)((((spi_data[1]&0x0F)*256.0f)+spi_data[2])/819.0f);

}

